<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$from = $_GET['from'] ?? '';
$to = $_GET['to'] ?? '';
$branch_filter = $_GET['branch'] ?? '';

$query = "SELECT h.id AS report_id, h.report_date, h.remarks, h.created_at, b.branch_name
          FROM till_report_headers h
          JOIN branches b ON b.id = h.branch_id
          WHERE 1=1";
$params = [];
$param_types = '';

if ($from && $to) {
  $query .= " AND h.report_date BETWEEN ? AND ?";
  $params[] = $from;
  $params[] = $to;
  $param_types .= 'ss';
}
if ($branch_filter) {
  $query .= " AND b.branch_name = ?";
  $params[] = $branch_filter;
  $param_types .= 's';
}
$query .= " ORDER BY h.report_date DESC, h.id DESC";

$stmt = $conn->prepare($query);
if (!$stmt) die("Query failed: " . $conn->error);
if ($params) $stmt->bind_param($param_types, ...$params);
$stmt->execute();
$report_results = $stmt->get_result();

$reports = [];
$grand_total = 0;
$total_declared = 0;

while ($row = $report_results->fetch_assoc()) {
  $report_id = $row['report_id'];

  $details = $conn->query("SELECT * FROM till_report_details WHERE report_id = $report_id")->fetch_all(MYSQLI_ASSOC);
  $cash_total = $mpesa_total = $visa_total = $credit_total = $stk_total = $declared_total = 0;

  foreach ($details as $d) {
    $tt_notes = $d['note_1000'] + $d['note_500'] + $d['note_200'] + $d['note_100'] + $d['note_50'];
    $drop = $d['drop1'] + $d['drop2'] + $d['drop3'];
    $cash = $tt_notes + $drop + $d['coins'];
    $cash_total += $cash;

    $mpesa_total += ($d['mpesa'] + $d['stk']);
    $stk_total += $d['stk'];
    $visa_total += $d['visa'];
    $credit_total += $d['credit'];
    $declared_total += $d['declared_total'];
  }

  $cheque_q = $conn->query("SELECT SUM(amount) AS total_cheques FROM till_report_cheques WHERE report_id = $report_id");
  $cheque_row = $cheque_q->fetch_assoc();
  $cheque_total = floatval($cheque_row['total_cheques'] ?? 0);

  $actual_total = $cash_total + $mpesa_total + $visa_total + $cheque_total + $credit_total;
  $variance = $actual_total - $declared_total;

  $grand_total += $actual_total;
  $total_declared += $declared_total;

  $reports[] = [
    'report_id' => $report_id,
    'branch_name' => $row['branch_name'],
    'report_date' => $row['report_date'],
    'cash' => $cash_total,
    'mpesa' => $mpesa_total,
    'stk' => $stk_total,
    'visa' => $visa_total,
    'cheques' => $cheque_total,
    'credit' => $credit_total,
    'total' => $actual_total,
    'declared' => $declared_total,
    'variance' => $variance,
    'remarks' => $row['remarks'],
    'created_at' => $row['created_at']
  ];
}

$branches = $conn->query("SELECT DISTINCT branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);
$netVariance = $grand_total - $total_declared;
$netClass = $netVariance < 0 ? 'variance-neg' : ($netVariance > 0 ? 'variance-pos' : 'text-muted');
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>🧾 Till Reports List</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background: #f8f9fa; font-size: 13px; }
    .summary { font-weight: bold; }
    .variance-pos { color: green; }
    .variance-neg { color: red; }
    .table-sm th, .table-sm td { vertical-align: middle !important; }
    .collapse-row { background: #fcfcfc; }
    @media print {
      .no-print { display: none; }
      body { font-size: 11px; margin: 0; }
    }
  </style>
</head>
<body>
<div class="container-fluid py-4">
  <div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
      <div class="d-flex justify-content-between align-items-center mb-3">
        <h5 class="mb-0">📊 Till Report Summary</h5>
        <div class="no-print">
          <a href="#" onclick="window.print()" class="btn btn-outline-dark btn-sm"><i class="fas fa-print me-1"></i>Print</a>
        </div>
      </div>

      <form method="GET" class="row g-3 mb-4">
        <div class="col-md-3">
          <label class="form-label">From</label>
          <input type="date" name="from" value="<?= htmlspecialchars($from) ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">To</label>
          <input type="date" name="to" value="<?= htmlspecialchars($to) ?>" class="form-control">
        </div>
        <div class="col-md-3">
          <label class="form-label">Branch</label>
          <select name="branch" class="form-select">
            <option value="">-- All Branches --</option>
            <?php foreach ($branches as $b): ?>
              <option value="<?= htmlspecialchars($b['branch_name']) ?>" <?= $branch_filter === $b['branch_name'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($b['branch_name']) ?>
              </option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3 d-flex align-items-end">
          <button type="submit" class="btn btn-dark w-100"><i class="fas fa-filter me-2"></i>Filter</button>
        </div>
      </form>

      <div class="alert alert-info fw-semibold summary">
        💰 Cashier Counted: KES <?= number_format($grand_total, 2) ?> |
        🧾 POS Expected: KES <?= number_format($total_declared, 2) ?> |
        🔁 Net Over/Short:
        <span class="<?= $netClass ?>">
          <?= ($netVariance > 0 ? '+' : '') . 'KES ' . number_format($netVariance, 2) ?>
        </span>
      </div>

      <div class="table-responsive">
        <table class="table table-sm table-bordered table-striped align-middle">
          <thead class="table-light text-center">
            <tr>
              <th>#</th>
              <th>Date</th>
              <th>Branch</th>
              <th>Cash</th>
              <th>MPESA+STK</th>
              <th>VISA</th>
              <th>Cheques</th>
              <th>Credit</th>
              <th>Recorded</th>
              <th>POS Expected</th>
              <th>Variance</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            <?php $i = 1; foreach ($reports as $r): ?>
              <tr class="text-center">
                <td><?= $i++ ?></td>
                <td><?= $r['report_date'] ?></td>
                <td><?= htmlspecialchars($r['branch_name']) ?></td>
                <td><?= number_format($r['cash'], 2) ?></td>
                <td><?= number_format($r['mpesa'], 2) ?><br><small class="text-muted">STK: <?= number_format($r['stk'], 2) ?></small></td>
                <td><?= number_format($r['visa'], 2) ?></td>
                <td><?= number_format($r['cheques'], 2) ?></td>
                <td><?= number_format($r['credit'], 2) ?></td>
                <td class="fw-bold text-success"><?= number_format($r['total'], 2) ?></td>
                <td><?= number_format($r['declared'], 2) ?></td>
                <td class="<?= $r['variance'] < 0 ? 'variance-neg' : 'variance-pos' ?>">
                  <?= ($r['variance'] > 0 ? '+' : '') . number_format($r['variance'], 2) ?>
                  <?php if (abs($r['variance']) >= 5000): ?>
                    <span class="badge bg-danger ms-1">⚠</span>
                  <?php endif; ?>
                </td>
                <td>
                  <a href="view_report.php?report_id=<?= $r['report_id'] ?>" class="btn btn-sm btn-primary mb-1"><i class="fas fa-eye"></i> View</a>
                  <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="collapse" data-bs-target="#details<?= $r['report_id'] ?>">Details ▼</button>
                </td>
              </tr>
              <tr class="collapse collapse-row" id="details<?= $r['report_id'] ?>">
                <td colspan="12">
                  <table class="table table-sm table-bordered mb-0">
                    <thead class="table-secondary text-center">
                      <tr>
                        <th>Till</th><th>Cashier</th><th>Register</th><th>Opening</th><th>Coins</th><th>Cash Total</th>
                        <th>MPESA</th><th>VISA</th><th>CREDIT</th><th>STK</th><th>Declared</th><th>Variance</th>
                      </tr>
                    </thead>
                    <tbody class="text-center">
                      <?php
                      $tills = $conn->query("SELECT * FROM till_report_details WHERE report_id = " . $r['report_id'])->fetch_all(MYSQLI_ASSOC);
                      foreach ($tills as $t):
                        $drop = $t['drop1'] + $t['drop2'] + $t['drop3'];
                        $notes = $t['note_1000'] + $t['note_500'] + $t['note_200'] + $t['note_100'] + $t['note_50'];
                        $cash = $drop + $notes + $t['coins'];
                        $total = $cash + $t['mpesa'] + $t['visa'] + $t['credit'] + $t['stk'] + $t['other'];
                        $declared = $t['declared_total'];
                        $v = $total - $declared;
                      ?>
                        <tr>
                          <td><?= $t['till_no'] ?></td>
                          <td><?= htmlspecialchars($t['cashier']) ?></td>
                          <td><?= $t['register'] ?></td>
                          <td><?= number_format($t['opening'], 2) ?></td>
                          <td><?= number_format($t['coins'], 2) ?></td>
                          <td><?= number_format($cash, 2) ?></td>
                          <td><?= number_format($t['mpesa'], 2) ?></td>
                          <td><?= number_format($t['visa'], 2) ?></td>
                          <td><?= number_format($t['credit'], 2) ?></td>
                          <td><?= number_format($t['stk'], 2) ?></td>
                          <td><?= number_format($declared, 2) ?></td>
                          <td class="<?= $v < 0 ? 'variance-neg' : 'variance-pos' ?>">
                            <?= ($v > 0 ? '+' : '') . number_format($v, 2) ?>
                            <?php if (abs($v) >= 5000): ?>
                              <span class="badge bg-danger ms-1">⚠</span>
                            <?php endif; ?>
                          </td>
                        </tr>
                      <?php endforeach; ?>
                    </tbody>
                  </table>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (empty($reports)): ?>
              <tr><td colspan="12" class="text-center text-muted">No reports found for selected filters.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="mt-3 no-print">
        <a href="cashier_report.php" class="btn btn-success btn-sm"><i class="fas fa-plus-circle me-1"></i> New Till Report</a>
      </div>
    </div>
  </div>
</div>

<!-- Bootstrap JS for collapsible functionality -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
