<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: record_deposit.php?error=Invalid+request");
    exit;
}

// Collect form data
$report_id        = isset($_POST['report_id']) ? (int)$_POST['report_id'] : null;
$deposit_amount   = isset($_POST['deposit_amount']) ? (float)$_POST['deposit_amount'] : 0;
$deposit_date     = $_POST['deposit_date'] ?? date('Y-m-d');
$reference_number = trim($_POST['reference_number'] ?? '');
$deposited_by     = trim($_POST['deposited_by'] ?? '');
$account_id       = isset($_POST['account_id']) ? (int)$_POST['account_id'] : null;
$remarks          = trim($_POST['remarks'] ?? '');
$deposit_type     = 'Cash';

// Validate required fields (without relying on session for branch)
if (!$report_id || !$deposit_amount || !$deposit_date || !$reference_number || !$deposited_by || !$account_id) {
    header("Location: record_deposit.php?error=Missing+required+fields");
    exit;
}

// ✅ Fetch branch_name from report_id
$branch_name = '';
$branch_stmt = $conn->prepare("
    SELECT b.branch_name
    FROM till_report_headers h
    JOIN branches b ON h.branch_id = b.id
    WHERE h.id = ?
");
$branch_stmt->bind_param("i", $report_id);
$branch_stmt->execute();
$branch_stmt->bind_result($branch_name);
$branch_stmt->fetch();
$branch_stmt->close();

if (!$branch_name) {
    header("Location: record_deposit.php?error=Invalid+report_id+or+branch+not+found");
    exit;
}

// ✅ Fetch bank_name from account_id
$bank_name = '';
$bank_stmt = $conn->prepare("SELECT bank_name FROM bank_accounts WHERE id = ?");
$bank_stmt->bind_param("i", $account_id);
$bank_stmt->execute();
$bank_stmt->bind_result($bank_name);
$bank_stmt->fetch();
$bank_stmt->close();

if (!$bank_name) {
    header("Location: record_deposit.php?error=Invalid+bank+account");
    exit;
}

// ✅ Handle optional deposit slip upload
$upload_path = '';
if (!empty($_FILES['deposit_slip']['name']) && $_FILES['deposit_slip']['error'] === UPLOAD_ERR_OK) {
    $ext = strtolower(pathinfo($_FILES['deposit_slip']['name'], PATHINFO_EXTENSION));
    $upload_filename = uniqid('cash_', true) . '.' . $ext;
    $upload_dir = dirname(__DIR__, 2) . '/uploads/slips/';
    $upload_path = 'uploads/slips/' . $upload_filename;

    if (!is_dir($upload_dir)) {
        mkdir($upload_dir, 0775, true);
    }

    move_uploaded_file($_FILES['deposit_slip']['tmp_name'], $upload_dir . $upload_filename);
}

// ✅ Insert into bank_deposits
$stmt = $conn->prepare("
    INSERT INTO bank_deposits (
        report_id, account_id, bank_name, deposit_type,
        deposit_amount, deposit_date, reference_number, deposited_by,
        branch_name, remarks, deposit_slip, created_at
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())
");

if (!$stmt) {
    die("Prepare failed: " . $conn->error);
}

$stmt->bind_param(
    "iissdssssss",
    $report_id,
    $account_id,
    $bank_name,
    $deposit_type,
    $deposit_amount,
    $deposit_date,
    $reference_number,
    $deposited_by,
    $branch_name,
    $remarks,
    $upload_path
);

// ✅ Execute and redirect
if ($stmt->execute()) {
    header("Location: record_deposit.php?success=Cash+deposit+saved+successfully");
    exit;
} else {
    error_log("SQL Error: " . $stmt->error);
    header("Location: record_deposit.php?error=Failed+to+save+cash+deposit");
    exit;
}
?>
