<?php
session_start();
require_once '../config/db.php';

if ($_SESSION['role'] !== 'Admin') {
    header("Location: unauthorized.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = trim($_POST['full_name']);
    $username = trim($_POST['username']);
    $id_number = trim($_POST['id_number']);
    $phone = trim($_POST['phone']);
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $branch_id = intval($_POST['branch_id']);
    $role_id = intval($_POST['role_id']);
    $status = $_POST['status'];

    if ($password !== $confirm_password) {
        $_SESSION['error'] = "Passwords do not match.";
        header("Location: list_users.php");
        exit;
    }

    $stmt = $conn->prepare("SELECT id FROM users WHERE username = ? OR email = ?");
    $stmt->bind_param("ss", $username, $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows > 0) {
        $_SESSION['error'] = "Username or email already exists.";
    } else {
        $hashed = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO users 
            (full_name, username, id_number, phone, email, password, branch_id, role_id, status, created_at) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
        $stmt->bind_param("sssssssis", $full_name, $username, $id_number, $phone, $email, $hashed, $branch_id, $role_id, $status);

        if ($stmt->execute()) {
            $_SESSION['success'] = "User created successfully.";
        } else {
            $_SESSION['error'] = "Failed to create user.";
        }
    }

    $stmt->close();
    header("Location: list_users.php");
    exit;
}
?>
