<?php
session_start();
require_once '../config/db.php';

if ($_SESSION['role'] !== 'Admin') {
    header("Location: unauthorized.php");
    exit;
}

if (isset($_GET['id'])) {
    $id = intval($_GET['id']);

    // Optional: protect yourself from deleting your own admin account
    if ($_SESSION['user_id'] == $id) {
        $_SESSION['error'] = "You cannot delete your own account.";
        header("Location: list_users.php");
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $id);
    
    if ($stmt->execute()) {
        $_SESSION['success'] = "User deleted.";
    } else {
        $_SESSION['error'] = "Failed to delete user.";
    }

    header("Location: list_users.php");
    exit;
}
?>
