<?php
session_start();
require_once '../config/db.php';

if ($_SESSION['role'] !== 'Admin') {
    header("Location: unauthorized.php");
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $full_name = trim($_POST['full_name']);
    $username = trim($_POST['username']);
    $id_number = trim($_POST['id_number']);
    $phone = trim($_POST['phone']);
    $branch_id = intval($_POST['branch_id']);
    $role_id = intval($_POST['role_id']);
    $status = $_POST['status'];

    // Prevent duplicate usernames
    $check = $conn->prepare("SELECT id FROM users WHERE username = ? AND id != ?");
    $check->bind_param("si", $username, $id);
    $check->execute();
    $check->store_result();

    if ($check->num_rows > 0) {
        $_SESSION['error'] = "Username already exists.";
    } else {
        $stmt = $conn->prepare("UPDATE users SET 
            full_name = ?, 
            username = ?, 
            id_number = ?, 
            phone = ?, 
            branch_id = ?, 
            role_id = ?, 
            status = ?, 
            updated_at = NOW()
            WHERE id = ?");
        $stmt->bind_param("ssssissi", $full_name, $username, $id_number, $phone, $branch_id, $role_id, $status, $id);

        if ($stmt->execute()) {
            $_SESSION['success'] = "User updated successfully.";
        } else {
            $_SESSION['error'] = "Failed to update user.";
        }
    }

    $check->close();
    header("Location: list_users.php");
    exit;
}
?>
