<?php
require_once __DIR__ . '/../config/openai.php';

function generateSmartInvoiceSummary($total, $pending, $overdue) {
  $data = [
    "model" => "gpt-3.5-turbo",
    "messages" => [
      [
        "role" => "system",
        "content" => "You are a professional financial assistant summarizing invoice statuses for a dashboard."
      ],
      [
        "role" => "user",
        "content" => "Summarize this: $total invoices created this week, $pending pending approval, $overdue overdue."
      ]
    ]
  ];

  $ch = curl_init("https://api.openai.com/v1/chat/completions");
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => [
      'Content-Type: application/json',
      'Authorization: Bearer ' . OPENAI_API_KEY
    ],
    CURLOPT_POSTFIELDS => json_encode($data),
  ]);

  $response = curl_exec($ch);
  if (curl_errno($ch)) return "⚠️ GPT Error: " . curl_error($ch);
  $json = json_decode($response, true);
  return $json['choices'][0]['message']['content'] ?? "⚠️ No response from AI.";
}
