<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout.php';

$date = $_GET['date'] ?? date('Y-m-d');
$branch_id = $_GET['branch_id'] ?? ($_SESSION['branch_id'] ?? 1);

// Fetch branch name
$branch_name = '';
$bq = $conn->query("SELECT branch_name FROM branches WHERE id = $branch_id");
if ($row = $bq->fetch_assoc()) {
    $branch_name = $row['branch_name'];
}

// TILL TOTALS (up to batch 4 only)
$till_sql = "SELECT 
    SUM(mpesa_1 + mpesa_2 + mpesa_3 + mpesa_4) AS mpesa_total,
    SUM(visa_1 + visa_2 + visa_3 + visa_4) AS visa_total,
    SUM(drop1_1 + drop2_1 + drop3_1 +
        drop1_2 + drop2_2 + drop3_2 +
        drop1_3 + drop2_3 + drop3_3 +
        drop1_4 + drop2_4 + drop3_4) AS cash_total
    FROM till_reports
    WHERE report_date = ? AND branch_id = ?";
$stmt = $conn->prepare($till_sql);
$stmt->bind_param("si", $date, $branch_id);
$stmt->execute();
$till = $stmt->get_result()->fetch_assoc();

$cash_total = $till['cash_total'] ?? 0;
$mpesa_total = $till['mpesa_total'] ?? 0;
$visa_total = $till['visa_total'] ?? 0;
$expected = $cash_total + $mpesa_total + $visa_total;

// BANK DEPOSITS
$deposit_sql = "SELECT SUM(deposit_amount) AS deposit_total
                FROM bank_deposits
                WHERE deposit_date = ? AND branch_name = ?";
$stmt2 = $conn->prepare($deposit_sql);
$stmt2->bind_param("ss", $date, $branch_name);
$stmt2->execute();
$deposit = $stmt2->get_result()->fetch_assoc();
$deposit_total = $deposit['deposit_total'] ?? 0;

// PETTY CASH
$petty_sql = "SELECT SUM(amount) AS petty_total
              FROM petty_cash_transactions
              WHERE transaction_date = ? AND branch_id = ?";
$stmt3 = $conn->prepare($petty_sql);
$stmt3->bind_param("si", $date, $branch_id);
$stmt3->execute();
$petty = $stmt3->get_result()->fetch_assoc();
$petty_total = $petty['petty_total'] ?? 0;

// Default actual = deposit + petty
$actual_default = $deposit_total + $petty_total;
?>

<div class="container mt-4">
    <h2 class="fw-bold">Accounts Portal – Daily Financial Summary</h2>

    <form class="row g-3 mb-4" method="get">
        <div class="col-md-3">
            <label>Date</label>
            <input type="date" name="date" value="<?= htmlspecialchars($date) ?>" class="form-control" required>
        </div>
        <div class="col-md-3">
            <label>Branch</label>
            <select name="branch_id" class="form-control" required>
                <?php
                $branches = $conn->query("SELECT id, branch_name FROM branches");
                while ($b = $branches->fetch_assoc()):
                ?>
                    <option value="<?= $b['id'] ?>" <?= $branch_id == $b['id'] ? 'selected' : '' ?>>
                        <?= htmlspecialchars($b['branch_name']) ?>
                    </option>
                <?php endwhile; ?>
            </select>
        </div>
        <div class="col-md-2 align-self-end">
            <button class="btn btn-primary">Filter</button>
        </div>
    </form>

    <div class="row g-4" id="summary-cards">
        <div class="col-md-3">
            <div class="card p-3 shadow-sm">
                <h6 class="text-muted">Expected Closing</h6>
                <h4 id="expected"><?= number_format($expected, 2) ?></h4>
                <input type="hidden" id="expected_val" value="<?= $expected ?>">
            </div>
        </div>
        <div class="col-md-3">
            <div class="card p-3 shadow-sm">
                <h6 class="text-muted">Actual Deposits + Petty</h6>
                <input type="number" class="form-control form-control-lg" id="actual_input"
                       value="<?= $actual_default ?>" step="0.01">
            </div>
        </div>
        <div class="col-md-3">
            <div id="variance_card" class="card p-3 shadow-sm bg-light">
                <h6 class="text-muted">Variance</h6>
                <h4 id="variance_text">KES <?= number_format($expected - $actual_default, 2) ?></h4>
            </div>
        </div>
        <div class="col-md-3 d-flex flex-column justify-content-between">
            <button class="btn btn-outline-warning mt-2" id="flagBtn" data-bs-toggle="modal" data-bs-target="#remarksModal">
                ⚠ Flag Discrepancy
            </button>
        </div>
    </div>
</div>

<!-- Modal for Variance Remarks -->
<div class="modal fade" id="remarksModal" tabindex="-1" aria-labelledby="remarksModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form class="modal-content" method="post" action="save_flag.php">
      <div class="modal-header">
        <h5 class="modal-title">Discrepancy Remarks</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="recon_date" value="<?= htmlspecialchars($date) ?>">
        <input type="hidden" name="branch_id" value="<?= (int)$branch_id ?>">
        <input type="hidden" name="expected" id="modal_expected" value="<?= $expected ?>">
        <input type="hidden" name="actual" id="modal_actual" value="<?= $actual_default ?>">
        <textarea name="remarks" class="form-control" rows="4" required placeholder="Explain the discrepancy..."></textarea>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-danger">Submit Remark</button>
      </div>
    </form>
  </div>
</div>

<!-- JS Script to Recalculate Variance Live -->
<script>
document.addEventListener('DOMContentLoaded', function () {
    const expected = parseFloat(document.getElementById('expected_val').value);
    const actualInput = document.getElementById('actual_input');
    const varianceText = document.getElementById('variance_text');
    const varianceCard = document.getElementById('variance_card');
    const modalActual = document.getElementById('modal_actual');

    function updateVariance() {
        const actual = parseFloat(actualInput.value) || 0;
        const variance = (expected - actual).toFixed(2);
        modalActual.value = actual;

        varianceText.innerText = `KES ${parseFloat(variance).toLocaleString(undefined, { minimumFractionDigits: 2 })}`;

        if (variance == 0) {
            varianceCard.classList.remove('bg-warning');
            varianceCard.classList.add('bg-success', 'text-white');
        } else {
            varianceCard.classList.remove('bg-success', 'text-white');
            varianceCard.classList.add('bg-warning');
        }
    }

    actualInput.addEventListener('input', updateVariance);
});
</script>
