<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$result = $conn->query("SELECT * FROM branches ORDER BY branch_name ASC");
?>

<div class="main-content">
  <h4 class="fw-bold text-primary mb-4"><i class="fas fa-code-branch"></i> Branch List</h4>

  <a href="add.php" class="btn btn-sm btn-primary mb-3"><i class="fas fa-plus me-1"></i> Add Branch</a>

  <?php include '../../includes/alerts.php'; ?>

  <div class="card shadow-sm">
    <div class="card-body table-responsive p-2">
      <table class="table table-bordered table-sm table-hover">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Branch</th>
            <th>Location</th>
            <th>Created</th>
          </tr>
        </thead>
        <tbody>
          <?php $n = 1; while ($b = $result->fetch_assoc()): ?>
            <tr>
              <td><?= $n++ ?></td>
              <td><?= htmlspecialchars($b['branch_name']) ?></td>
              <td><?= htmlspecialchars($b['location']) ?></td>
              <td><?= date('d-M-Y', strtotime($b['created_at'])) ?></td>
            </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
