<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: list.php");
  exit;
}

if ($_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  $_SESSION['error'] = "CSRF token mismatch.";
  header("Location: add.php");
  exit;
}

$branch_name = trim($_POST['branch_name']);
$location = trim($_POST['location']);

$stmt = $conn->prepare("INSERT INTO branches (branch_name, location) VALUES (?, ?)");
$stmt->bind_param("ss", $branch_name, $location);

if ($stmt->execute()) {
  $_SESSION['success'] = "✅ Branch added successfully.";
  header("Location: list.php");
} else {
  $_SESSION['error'] = "❌ Failed: " . $stmt->error;
  header("Location: add.php");
}
