<?php
require_once('../../../config/db.php');

header('Content-Type: application/json');

if (!isset($_GET['loading_id']) || !is_numeric($_GET['loading_id'])) {
    echo json_encode([]);
    exit;
}

$loading_id = (int)$_GET['loading_id'];

$query = "
    SELECT 
        li.sku_id, 
        s.name, 
        li.crates_loaded
    FROM loading_items li
    JOIN skus s ON li.sku_id = s.id
    WHERE li.loading_id = ?
";

$stmt = $conn->prepare($query);
$stmt->bind_param('i', $loading_id);
$stmt->execute();
$result = $stmt->get_result();

$items = [];

while ($row = $result->fetch_assoc()) {
    $items[] = [
        'sku_id' => $row['sku_id'],
        'name' => $row['name'],
        'crates_loaded' => $row['crates_loaded']
    ];
}

echo json_encode($items);
exit;
?>
