<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Fetch loadings with vehicle and route info
$sql = "
    SELECT l.*, v.plate_number, r.name AS route_name
    FROM loadings l
    JOIN vehicles v ON l.vehicle_id = v.id
    JOIN routes r ON l.route_id = r.id
    ORDER BY l.loading_date DESC
";
$result = $conn->query($sql);
if (!$result) die("Query Failed: " . $conn->error);
$loadings = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="main-content container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary mb-0">
            <i class="fas fa-truck-loading me-2"></i> Bread Loading Records
        </h4>
        <a href="loading.php" class="btn btn-success"><i class="fas fa-plus-circle me-1"></i> New Loading</a>
    </div>

    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php elseif (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <div class="card shadow-sm border-0">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-hover align-middle">
                <thead class="table-light">
                    <tr class="text-center">
                        <th>#</th>
                        <th>Date</th>
                        <th>Vehicle</th>
                        <th>Route</th>
                        <th>Mileage Start</th>
                        <th>Crates Total</th>
                        <th>Expected Value</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($loadings)): ?>
                        <tr><td colspan="8" class="text-center text-muted">No loading records found.</td></tr>
                    <?php else: ?>
                        <?php foreach ($loadings as $index => $row): ?>
                            <?php
                            $loading_id = $row['id'];
                            $crate_stmt = $conn->prepare("
                                SELECT 
                                    IFNULL(SUM(li.crates_loaded), 0) AS crates_total,
                                    IFNULL(SUM(li.crates_loaded * s.price_per_crate), 0) AS value_total
                                FROM loading_items li
                                JOIN skus s ON li.sku_id = s.id
                                WHERE li.loading_id = ?
                            ");
                            $crate_stmt->bind_param("i", $loading_id);
                            $crate_stmt->execute();
                            $crate_result = $crate_stmt->get_result();
                            $crate_data = $crate_result->fetch_assoc();
                            ?>
                            <tr>
                                <td class="text-center"><?= $index + 1 ?></td>
                                <td><?= date("Y-m-d", strtotime($row['loading_date'])) ?></td>
                                <td><?= htmlspecialchars($row['plate_number']) ?></td>
                                <td><?= htmlspecialchars($row['route_name']) ?></td>
                                <td class="text-end"><?= number_format($row['mileage_start']) ?> km</td>
                                <td class="text-center"><?= number_format($crate_data['crates_total']) ?></td>
                                <td class="text-end">Ksh <?= number_format($crate_data['value_total'], 2) ?></td>
                                <td class="text-center">
                                    <a href="print_loading_sheet.php?id=<?= $loading_id ?>" class="btn btn-sm btn-outline-primary" target="_blank">
                                        <i class="fas fa-print"></i> Print
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
