<?php
session_start();
require_once '../../config/db.php';

$loading_id = (int) ($_GET['id'] ?? 0);
if ($loading_id <= 0) die("Invalid loading ID.");

// Fetch loading info
$stmt = $conn->prepare("
    SELECT l.*, v.plate_number, v.driver_name, r.name AS route_name
    FROM loadings l
    JOIN vehicles v ON l.vehicle_id = v.id
    JOIN routes r ON l.route_id = r.id
    WHERE l.id = ?
");
$stmt->bind_param("i", $loading_id);
$stmt->execute();
$loading = $stmt->get_result()->fetch_assoc();
if (!$loading) die("Loading record not found.");

// Fetch bread items
$stmt = $conn->prepare("
    SELECT s.name AS sku_name, li.crates_loaded, s.price_per_crate
    FROM loading_items li
    JOIN skus s ON li.sku_id = s.id
    WHERE li.loading_id = ?
");
$stmt->bind_param("i", $loading_id);
$stmt->execute();
$items = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// Calculate totals
$total_crates = 0;
$total_value = 0;
foreach ($items as $item) {
    $total_crates += $item['crates_loaded'];
    $total_value += $item['crates_loaded'] * $item['price_per_crate'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Loading Sheet #<?= $loading_id ?></title>
  <style>
    @page {
      size: 80mm auto;
      margin: 5;
    }
    body {
      width: 60mm;
      font-family: 'Arial', sans-serif;
      font-size: 13px;
      margin: 0;
      padding: 8px;
      color: #000;
    }
    .center { text-align: center; }
    .bold { font-weight: bold; }
    .line { border-top: 2px dashed #000; margin: 8px 0; }
    table {
      width: 100%;
      border-collapse: collapse;
      font-size: 13px;
    }
    th, td {
      padding: 4px 0;
    }
    th {
      border-bottom: 1px solid #000;
      font-weight: bold;
      text-align: left;
    }
    .summary, .signature {
      margin-top: 12px;
      font-weight: bold;
    }
    .signature {
      margin-top: 24px;
    }
    .signature small {
      font-weight: normal;
    }
    .footer {
      font-size: 11px;
      text-align: center;
      margin-top: 18px;
      border-top: 1px solid #ccc;
      padding-top: 6px;
    }
    h3 {
      font-size: 16px;
      font-weight: 900;
      margin: 0 0 6px 0;
    }
    .table-summary td {
      padding: 2px 0;
    }
    @media print {
      body { zoom: 1.2; }
    }
  </style>
</head>
<body onload="window.print()">
<div class="container">
  <div class="center">
    <h3>DELTA SUPERSTORES LTD</h3>
    <div style="font-size:14px; font-weight:bold;">Bread Loading Sheet</div>
    <div class="line"></div>
  </div>

  <p>
    <span class="bold">Date:</span> <?= htmlspecialchars($loading['loading_date']) ?><br>
    <span class="bold">Vehicle:</span> <?= htmlspecialchars($loading['plate_number']) ?><br>
    <span class="bold">Driver:</span> <?= htmlspecialchars($loading['driver_name']) ?><br>
    <span class="bold">Route:</span> <?= htmlspecialchars($loading['route_name']) ?><br>
    <span class="bold">Mileage Start:</span> <?= htmlspecialchars($loading['mileage_start']) ?><br>
  </p>

  <div class="line"></div>

  <table>
    <thead>
      <tr>
        <th>SKU</th>
        <th style="text-align:right;">Crates</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($items as $item): ?>
      <tr>
        <td><strong><?= htmlspecialchars($item['sku_name']) ?></strong></td>
        <td style="text-align:right;"><strong><?= number_format($item['crates_loaded']) ?></strong></td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>

  <div class="line"></div>

  <div class="summary">
    <p>Total Crates: <span style="float:right;"><?= number_format($total_crates) ?></span></p>
    <p>Expected Value: <span style="float:right;">Ksh <?= number_format($total_value, 2) ?></span></p>
  </div>

  <div class="signature">
    ___________________________<br>
    <small>Driver Signature</small>
  </div>

  <div class="signature">
    ___________________________<br>
    <small>Clerk Signature</small>
  </div>

  <div class="footer">
    Route: <?= htmlspecialchars($loading['route_name']) ?> | Sheet #<?= $loading_id ?><br>
    Printed via SmartPay360 @ <?= date("Y-m-d H:i") ?>
  </div>
</div>
</body>
</html>
