<?php
session_start();
require_once '../../config/db.php';

$loading_id = (int)($_GET['id'] ?? 0);
if ($loading_id <= 0) die("Invalid ID.");

// Fetch loading session
$stmt = $conn->prepare("
    SELECT l.*, v.plate_number, v.driver_name, r.name AS route_name
    FROM loadings l
    JOIN vehicles v ON l.vehicle_id = v.id
    JOIN routes r ON l.route_id = r.id
    WHERE l.id = ?
");
if (!$stmt) {
    die("Query Error: " . $conn->error);
}
$stmt->bind_param('i', $loading_id);
$stmt->execute();
$result = $stmt->get_result();
$loading = $result->fetch_assoc();

if (!$loading) die("Loading session not found.");

// Fetch loaded SKUs
$skus = [];
$stmt = $conn->prepare("
    SELECT s.name AS sku_name, s.price_per_crate, li.crates_loaded
    FROM loading_items li
    JOIN skus s ON li.sku_id = s.id
    WHERE li.loading_id = ?
");
$stmt->bind_param('i', $loading_id);
$stmt->execute();
$res_skus = $stmt->get_result();
while ($row = $res_skus->fetch_assoc()) {
    $skus[] = $row;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Loading Sheet</title>
<style>
    @page {
        size: 80mm auto;
        margin: 0;
    }
    body {
        width: 80mm;
        margin: 0;
        padding: 0;
        font-family: 'Arial', sans-serif;
        font-size: 15px;
        color: #000;
        text-align: center;
    }
    .container {
        width: 100%;
        padding: 5px 3px;
    }
    h2 {
        margin: 5px 0 10px 0;
        font-size: 22px;
        font-weight: bold;
    }
    .logo img {
        width: 75px;
        height: auto;
        margin-bottom: 5px;
    }
    .section {
        margin-top: 5px;
        margin-bottom: 5px;
        font-size: 15px;
    }
    .section div {
        margin-bottom: 5px;
    }
    .description {
        margin-top: 8px;
        font-size: 15px;
        padding: 0 5px;
    }
    .line {
        border-top: 2px dashed #000;
        margin: 10px 0;
    }
    .signature-area {
        margin-top: 30px;
        font-size: 14px;
    }
    .small-text {
        font-size: 12px;
        color: #555;
        margin-top: 10px;
    }
    table {
        width: 100%;
        font-size: 14px;
        margin-top: 10px;
        border-collapse: collapse;
    }
    td, th {
        padding: 3px;
    }
    .summary {
        margin-top: 10px;
    }
    strong {
        font-weight: bold;
    }
    @media print {
        body {
            zoom: 1.8;
        }
    }
</style>
<script src="https://cdn.jsdelivr.net/npm/qrious/dist/qrious.min.js"></script>
</head>

<body onload="window.print()">

<div class="container">

    <!-- Logo -->
    <div class="logo">
        <img src="../../assets/images/logo.png" alt="Company Logo">
    </div>

    <!-- Title -->
    <h2>LOADING SHEET</h2>

    <!-- Loading Details -->
    <div class="section">
        <div><strong>Date:</strong> <?= htmlspecialchars($loading['loading_date']) ?> <?= date('H:i') ?></div>
        <div><strong>Vehicle:</strong> <?= htmlspecialchars($loading['plate_number']) ?></div>
        <div><strong>Driver:</strong> <?= htmlspecialchars($loading['driver_name']) ?></div>
        <div><strong>Route:</strong> <?= htmlspecialchars($loading['route_name']) ?></div>
        <div><strong>Mileage Start:</strong> <?= htmlspecialchars($loading['mileage_start']) ?></div>
    </div>

    <?php if (!empty($loading['remarks'])): ?>
    <div class="description">
        <strong>Remarks:</strong><br><?= htmlspecialchars($loading['remarks']) ?>
    </div>
    <?php endif; ?>

    <div class="line"></div>

    <!-- Bread Loaded -->
    <table>
        <thead>
            <tr>
                <th style="text-align:left;">Bread SKU</th>
                <th style="text-align:right;">Crates</th>
            </tr>
        </thead>
        <tbody>
        <?php
        $total_crates = 0;
        $total_value = 0;
        foreach ($skus as $sku):
            $line_total = $sku['crates_loaded'] * $sku['price_per_crate'];
            $total_crates += $sku['crates_loaded'];
            $total_value += $line_total;
        ?>
            <tr>
                <td style="text-align:left;"><?= htmlspecialchars($sku['sku_name']) ?></td>
                <td style="text-align:right;"><?= (int)$sku['crates_loaded'] ?></td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>

    <div class="line"></div>

    <div class="summary">
        <div><strong>Total Crates:</strong> <?= $total_crates ?></div>
        <div><strong>Expected Value:</strong> Ksh <?= number_format($total_value, 2) ?></div>
    </div>

    <div class="line"></div>

    <!-- Signatures -->
    <div class="signature-area">
        ___________________________<br>
        Driver Signature
    </div>

    <div class="signature-area">
        ___________________________<br>
        Dispatcher Signature
    </div>

    <div class="signature-area" style="margin-top:20px;">
        <strong>[ Company Stamp Here ]</strong>
    </div>

    <!-- QR Code Centered -->
    <div class="qr" style="margin-top: 10px;">
        <canvas id="qr-code"></canvas>
    </div>

    <div class="small-text">
        Printed by SmartPay360
    </div>

</div>

<script>
// Generate QR Code based on Loading ID
var qr = new QRious({
    element: document.getElementById('qr-code'),
    value: "LOADING-ID:<?= htmlspecialchars($loading['id']) ?>",
    size: 80,
    level: 'H'
});
</script>

</body>
</html>
