<?php
session_start();
require_once '../../config/db.php';


// Handle Add or Update
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = isset($_POST['id']) ? (int) $_POST['id'] : 0;
    $bank_name = trim($_POST['bank_name']);
    $account_number = trim($_POST['account_number']);
    $branch_name = trim($_POST['branch_name']);
    $account_name = trim($_POST['account_name']);
    $status = $_POST['status'];

    if ($id > 0) {
        $stmt = $conn->prepare("UPDATE bank_accounts SET bank_name=?, account_number=?, branch_name=?, account_name=?, status=? WHERE id=?");
        $stmt->bind_param("sssssi", $bank_name, $account_number, $branch_name, $account_name, $status, $id);
    } else {
        $stmt = $conn->prepare("INSERT INTO bank_accounts (bank_name, account_number, branch_name, account_name, status) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("sssss", $bank_name, $account_number, $branch_name, $account_name, $status);
    }

    $stmt->execute();
    header("Location: bank_accounts.php");
    exit;
}

// Fetch all accounts
$accounts = $conn->query("SELECT * FROM bank_accounts ORDER BY bank_name ASC")->fetch_all(MYSQLI_ASSOC);

// If editing
$edit = null;
if (isset($_GET['edit'])) {
    $id = (int)$_GET['edit'];
    $stmt = $conn->prepare("SELECT * FROM bank_accounts WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $edit = $stmt->get_result()->fetch_assoc();
}
include '../../includes/layout2.php';
?>

<div class="container mt-4">
    <h3 class="mb-4 fw-bold">Bank Account Management</h3>

    <form method="POST" class="card p-4 mb-5 shadow-sm">
        <input type="hidden" name="id" value="<?= $edit['id'] ?? '' ?>">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Bank Name</label>
                <input type="text" name="bank_name" class="form-control" value="<?= $edit['bank_name'] ?? '' ?>" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Account Number</label>
                <input type="text" name="account_number" class="form-control" value="<?= $edit['account_number'] ?? '' ?>" required>
            </div>
            <div class="col-md-4">
                <label class="form-label">Branch Name</label>
                <input type="text" name="branch_name" class="form-control" value="<?= $edit['branch_name'] ?? '' ?>" required>
            </div>
            <div class="col-md-6">
                <label class="form-label">Account Name</label>
                <input type="text" name="account_name" class="form-control" value="<?= $edit['account_name'] ?? '' ?>" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="active" <?= (isset($edit['status']) && $edit['status'] === 'active') ? 'selected' : '' ?>>Active</option>
                    <option value="inactive" <?= (isset($edit['status']) && $edit['status'] === 'inactive') ? 'selected' : '' ?>>Inactive</option>
                </select>
            </div>
            <div class="col-md-3 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Save Bank Account</button>
            </div>
        </div>
    </form>

    <h5 class="mb-3">Bank Accounts List</h5>
    <table class="table table-bordered table-striped table-hover">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Bank</th>
                <th>Account Name</th>
                <th>Account No</th>
                <th>Branch</th>
                <th>Status</th>
                <th>Created</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($accounts as $i => $a): ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= htmlspecialchars($a['bank_name']) ?></td>
                    <td><?= htmlspecialchars($a['account_name']) ?></td>
                    <td><?= htmlspecialchars($a['account_number']) ?></td>
                    <td><?= htmlspecialchars($a['branch_name']) ?></td>
                    <td><span class="badge bg-<?= $a['status'] === 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($a['status']) ?></span></td>
                    <td><?= date('Y-m-d', strtotime($a['created_at'])) ?></td>
                    <td>
                        <a href="?edit=<?= $a['id'] ?>" class="btn btn-sm btn-outline-primary">Edit</a>
                    </td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>
</div>
