<?php
session_start();
require_once '../../config/db.php';

if (!isset($_GET['id'])) {
    die("Missing cheque ID.");
}

$cheque_id = (int) $_GET['id'];

// Step 1: Fetch the cheque to get its leaf ID
$stmt = $conn->prepare("SELECT cheque_leaf_id FROM cheques WHERE id = ?");
$stmt->bind_param("i", $cheque_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    die("Cheque not found.");
}

$row = $result->fetch_assoc();
$cheque_leaf_id = $row['cheque_leaf_id'];

// Step 2: Update cheque and leaf as cancelled
$conn->query("UPDATE cheques SET status = 'cancelled' WHERE id = $cheque_id");
$conn->query("UPDATE cheque_leaves SET status = 'cancelled' WHERE id = $cheque_leaf_id");

// Step 3: Redirect
header("Location: list_cheques.php?cancelled=1");
exit;
