<?php
session_start();
require_once '../../config/db.php';


// Handle add new cheque book
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $bank_account_id = (int) $_POST['bank_account_id'];
    $book_number = trim($_POST['book_number']);
    $start_serial = (int) $_POST['start_serial'];
    $end_serial = (int) $_POST['end_serial'];
    $issued_date = $_POST['issued_date'];
    $status = $_POST['status'];

    // Insert into cheque_books
    $stmt = $conn->prepare("INSERT INTO cheque_books (bank_account_id, book_number, start_serial, end_serial, issued_date, status) VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("isisss", $bank_account_id, $book_number, $start_serial, $end_serial, $issued_date, $status);
    $stmt->execute();
    $book_id = $stmt->insert_id;

    // Auto-generate leaves
    for ($i = $start_serial; $i <= $end_serial; $i++) {
        $conn->query("INSERT INTO cheque_leaves (cheque_book_id, serial_number) VALUES ($book_id, $i)");
    }

    header("Location: cheque_books.php");
    exit;
}

// Fetch bank accounts
$accounts = $conn->query("SELECT * FROM bank_accounts WHERE status='active'")->fetch_all(MYSQLI_ASSOC);

// Fetch all cheque books
$books = $conn->query("
    SELECT cb.*, ba.bank_name, ba.account_number 
    FROM cheque_books cb
    JOIN bank_accounts ba ON cb.bank_account_id = ba.id
    ORDER BY cb.issued_date DESC
")->fetch_all(MYSQLI_ASSOC);
include '../../includes/layout2.php';
?>

<div class="container mt-4">
    <h3 class="fw-bold mb-4">Cheque Book Management</h3>

    <form method="POST" class="card p-4 mb-5 shadow-sm">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Bank Account</label>
                <select name="bank_account_id" class="form-select" required>
                    <option value="">-- Select Account --</option>
                    <?php foreach ($accounts as $a): ?>
                        <option value="<?= $a['id'] ?>"><?= $a['bank_name'] ?> - <?= $a['account_number'] ?></option>
                    <?php endforeach ?>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Book Number</label>
                <input type="text" name="book_number" class="form-control" required>
            </div>
            <div class="col-md-2">
                <label class="form-label">Start Serial</label>
                <input type="number" name="start_serial" class="form-control" required>
            </div>
            <div class="col-md-2">
                <label class="form-label">End Serial</label>
                <input type="number" name="end_serial" class="form-control" required>
            </div>
            <div class="col-md-3">
                <label class="form-label">Issued Date</label>
                <input type="date" name="issued_date" class="form-control" required>
            </div>
            <div class="col-md-2">
                <label class="form-label">Status</label>
                <select name="status" class="form-select">
                    <option value="active">Active</option>
                    <option value="exhausted">Exhausted</option>
                </select>
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">Save Book</button>
            </div>
        </div>
    </form>

    <h5 class="mb-3">All Cheque Books</h5>
    <table class="table table-bordered table-hover">
        <thead class="table-light">
            <tr>
                <th>#</th>
                <th>Bank</th>
                <th>Book No</th>
                <th>Serial Range</th>
                <th>Issued Date</th>
                <th>Status</th>
                <th>Leaves</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($books as $i => $b): 
                $leafCount = $conn->query("SELECT COUNT(*) as total FROM cheque_leaves WHERE cheque_book_id = " . $b['id'])->fetch_assoc()['total'];
            ?>
                <tr>
                    <td><?= $i + 1 ?></td>
                    <td><?= $b['bank_name'] ?> (<?= $b['account_number'] ?>)</td>
                    <td><?= $b['book_number'] ?></td>
                    <td><?= $b['start_serial'] ?> - <?= $b['end_serial'] ?></td>
                    <td><?= $b['issued_date'] ?></td>
                    <td><span class="badge bg-<?= $b['status'] === 'active' ? 'success' : 'secondary' ?>"><?= ucfirst($b['status']) ?></span></td>
                    <td><?= $leafCount ?></td>
                </tr>
            <?php endforeach ?>
        </tbody>
    </table>
</div>
