<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Fetch suppliers
$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name ASC");

// Auto-generate Goods Return Note number (simple example)
$autoReturnNoteNo = 'GRN-' . date('Ymd') . '-' . rand(100, 999);
?>

<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h4 class="fw-bold text-primary">
      <i class="fas fa-file-alt me-2"></i> Add Credit Note / Goods Return Note
    </h4>
    <a href="list.php" class="btn btn-outline-secondary">
      <i class="fas fa-list me-1"></i> View All
    </a>
  </div>

  <form method="POST" action="save_credit_note.php" enctype="multipart/form-data" class="card p-4 shadow bg-white border rounded-3">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">

    <div class="row g-3 mb-3">
      <div class="col-md-4">
        <label class="form-label fw-semibold">Supplier</label>
        <select name="supplier_id" id="supplier_id" class="form-select" required onchange="fetchInvoices(this.value)">
          <option value="">-- Select Supplier --</option>
          <?php while ($s = $suppliers->fetch_assoc()): ?>
            <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label fw-semibold">Type</label>
        <select name="note_type" id="note_type" class="form-select" required onchange="handleNoteTypeChange(this.value)">
          <option value="">-- Select Type --</option>
          <option value="Credit Note">Credit Note</option>
          <option value="Goods Return Note">Goods Return Note</option>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label fw-semibold">Note Number</label>
        <input type="text" name="credit_note_number" id="credit_note_number" class="form-control" placeholder="Enter or auto-filled" required>
      </div>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label fw-semibold">Date</label>
        <input type="date" name="credit_date" class="form-control" required value="<?= date('Y-m-d') ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label fw-semibold">Amount (KES)</label>
        <input type="number" name="amount" step="0.01" class="form-control" required placeholder="0.00">
      </div>
    </div>

    <div class="mb-3">
      <label class="form-label fw-semibold">Reason / Description</label>
      <select name="reason" id="reason" class="form-select" required onchange="updateDescriptionNote()">
        <option value="">-- Select Reason --</option>
        <option value="Damaged Goods">Damaged Goods</option>
        <option value="Short Expiry">Short Expiry</option>
        <option value="Not Ordered Goods">Not Ordered Goods</option>
        <option value="Supplier Discount">Supplier Discount</option>
        <option value="Goods Not Delivered">Goods Not Delivered</option>
      </select>
    </div>

    <div class="mb-3">
      <label class="form-label fw-semibold">Auto Description Note</label>
      <textarea id="description_note" rows="2" class="form-control bg-light" readonly placeholder="Auto description will appear here..."></textarea>
    </div>

    <div class="row g-3 mb-3">
      <div class="col-md-6">
        <label class="form-label fw-semibold">Link to Invoice (Optional)</label>
        <select name="invoice_id" id="invoice_select" class="form-select">
          <option value="">-- None --</option>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label fw-semibold">Upload Credit Note (PDF Optional)</label>
        <input type="file" name="credit_note_file" class="form-control" accept=".pdf">
      </div>
    </div>

    <div class="text-end mt-4">
      <button type="submit" class="btn btn-primary px-4">
        <i class="fas fa-save me-1"></i> Save
      </button>
    </div>
  </form>
</div>

<script>
// Auto-fill only for Goods Return Note
function handleNoteTypeChange(type) {
  const noteInput = document.getElementById('credit_note_number');
  if (type === 'Goods Return Note') {
    noteInput.value = '<?= $autoReturnNoteNo ?>';
    noteInput.readOnly = false;
  } else {
    noteInput.value = '';
    noteInput.readOnly = false;
  }
}

// Predefined short descriptions
function updateDescriptionNote() {
  const reason = document.getElementById('reason').value;
  const descField = document.getElementById('description_note');
  let description = '';

  switch (reason) {
    case 'Damaged Goods':
      description = 'Returned due to physical damage during delivery or handling.';
      break;
    case 'Short Expiry':
      description = 'Products near expiry; returned or discounted accordingly.';
      break;
    case 'Not Ordered Goods':
      description = 'Items delivered were not part of the original order.';
      break;
    case 'Supplier Discount':
      description = 'Discount applied as per supplier agreement or promotion.';
      break;
    case 'Goods Not Delivered':
      description = 'Credit issued for goods invoiced but not delivered.';
      break;
    default:
      description = '';
  }

  descField.value = description;
}

// Fetch invoices by supplier via AJAX
function fetchInvoices(supplierId) {
  fetch("fetch_invoices.php?supplier_id=" + supplierId)
    .then(res => res.json())
    .then(data => {
      const select = document.getElementById("invoice_select");
      select.innerHTML = '<option value="">-- None --</option>';
      data.forEach(inv => {
        const option = document.createElement("option");
        const formattedTotal = parseFloat(inv.total_amount).toLocaleString('en-KE', {
          style: 'currency',
          currency: 'KES'
        });
        option.value = inv.id;
        option.textContent = `${inv.invoice_number} (${inv.invoice_date}) - Total: ${formattedTotal}`;
        select.appendChild(option);
      });
    });
}
</script>
