<?php
require_once '../../config/db.php';
require_once '../../lib/ZKTeco.php';

use ZKTeco\ZKTeco;

$zk = new ZKTeco('192.168.1.247');

try {
    $zk->connect();
    $logs = $zk->getAttendance();

    if (!is_array($logs) || count($logs) === 0) {
        echo "⚠️ No logs found.";
        exit;
    }

    $grouped = [];

    foreach ($logs as $log) {
        if (!isset($log['uid'], $log['timestamp'])) continue;

        $uid = $log['uid'];
        $timestamp = $log['timestamp'];
        $date = date('Y-m-d', strtotime($timestamp));

        // Get staff ID and branch
        $stmt = $conn->prepare("SELECT staff_id, branch_id FROM staff WHERE zk_uid = ?");
        $stmt->bind_param("s", $uid);
        $stmt->execute();
        $stmt->bind_result($staff_id, $branch_id);
        $stmt->fetch();
        $stmt->close();

        if (!$staff_id) continue;

        $grouped[$staff_id][$date][] = [
            'timestamp' => $timestamp,
            'branch_id' => $branch_id
        ];
    }

    $inserted = 0;
    foreach ($grouped as $staff_id => $dates) {
        foreach ($dates as $date => $entries) {
            usort($entries, fn($a, $b) => strtotime($a['timestamp']) <=> strtotime($b['timestamp']));
            $in_time = $entries[0]['timestamp'];
            $out_time = end($entries)['timestamp'];
            $branch_id = $entries[0]['branch_id'];
            $status = 'present';
            $marked_by = 1;

            $stmt = $conn->prepare("
                INSERT INTO attendance (staff_id, branch_id, attendance_date, status, in_time, out_time, marked_by, marked_at)
                VALUES (?, ?, ?, ?, ?, ?, ?, NOW())
                ON DUPLICATE KEY UPDATE
                    in_time = LEAST(in_time, VALUES(in_time)),
                    out_time = GREATEST(out_time, VALUES(out_time)),
                    updated_at = NOW()
            ");
            $stmt->bind_param("sissssi", $staff_id, $branch_id, $date, $status, $in_time, $out_time, $marked_by);
            $stmt->execute();
            $inserted++;
        }
    }

    echo "✅ Synced $inserted attendance records.";
} catch (Exception $e) {
    echo "❌ Error: " . $e->getMessage();
}
