<?php
session_start();
require_once '../../config/db.php';
include_once '../../includes/layout2.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'] ?? '';
$current_branch = $_SESSION['branch_id'] ?? 0;
$current_role = $_SESSION['role'] ?? 'User';

// Generate CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Fetch vehicles
$vehicles = [];
$vehicle_sql = ($current_role === 'Admin') ? 
    "SELECT id, plate_number FROM vehicles ORDER BY plate_number ASC" :
    "SELECT id, plate_number FROM vehicles WHERE branch_id = $current_branch ORDER BY plate_number ASC";
$result = $conn->query($vehicle_sql);
while ($row = $result->fetch_assoc()) {
    $vehicles[] = $row;
}
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary"><i class="fas fa-tools me-2"></i> Record Vehicle Maintenance</h4>
        <a href="maintenance_logs.php" class="btn btn-secondary"><i class="fas fa-list me-1"></i> View Logs</a>
    </div>

    <form method="POST" action="save_maintenance.php" class="card shadow p-4">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Vehicle *</label>
                <select name="vehicle_id" class="form-select select2" required>
                    <option value="">-- Select Vehicle --</option>
                    <?php foreach ($vehicles as $v): ?>
                        <option value="<?= $v['id'] ?>"><?= htmlspecialchars($v['plate_number']) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Date of Maintenance *</label>
                <input type="date" name="maintenance_date" class="form-control" required value="<?= date('Y-m-d') ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Service Type *</label>
                <input type="text" name="service_type" class="form-control" required placeholder="e.g., Oil Change, Engine Check">
            </div>
            <div class="col-md-6">
                <label class="form-label">Garage / Service Center</label>
                <input type="text" name="garage_name" class="form-control" placeholder="Optional">
            </div>
            <div class="col-md-3">
                <label class="form-label">Odometer (km)</label>
                <input type="number" step="0.1" name="odometer" class="form-control">
            </div>
            <div class="col-md-3">
                <label class="form-label">Cost (KES)</label>
                <input type="number" step="0.01" name="cost" class="form-control">
            </div>
            <div class="col-12">
                <label class="form-label">Remarks</label>
                <textarea name="remarks" class="form-control" rows="2"></textarea>
            </div>
        </div>
        <div class="mt-4">
            <button type="submit" class="btn btn-primary px-4"><i class="fas fa-save me-1"></i> Save Maintenance</button>
        </div>
    </form>
</div>

<?php include_once '../../includes/footer.php'; ?>

<!-- JS plugins -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $('.select2').select2();
    });
</script>
