<?php
session_start();
require_once __DIR__ . '/../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

// Session fallback safety
$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;
$branch_filter = isset($_GET['branch']) ? intval($_GET['branch']) : 0;

// Fetch branches (admin only)
$branches = [];
if ($current_role === 'Admin') {
    $result = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");
    if ($result) {
        while ($row = $result->fetch_assoc()) {
            $branches[] = $row;
        }
    }
}

// Fetch vehicles
$query = "
SELECT v.*, b.branch_name, d.full_name AS driver_name
FROM vehicles v
LEFT JOIN branches b ON v.branch_id = b.id
LEFT JOIN drivers d ON v.assigned_driver_id = d.id
WHERE 1=1
";

if ($current_role !== 'Admin') {
    $query .= " AND v.branch_id = $current_branch";
} elseif ($branch_filter > 0) {
    $query .= " AND v.branch_id = $branch_filter";
}

$query .= " ORDER BY v.plate_number ASC";
$vehicles = $conn->query($query);
if (!$vehicles) {
    die("Query Error: " . $conn->error);
}

include_once __DIR__ . '/../../includes/layout2.php';
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary"><i class="fas fa-truck me-2"></i> Fleet Vehicles</h4>
        <a href="add_vehicle.php" class="btn btn-success"><i class="fas fa-plus-circle"></i> Add Vehicle</a>
    </div>

    <!-- Flash Alerts -->
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php endif; ?>
    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <?php if ($current_role === 'Admin'): ?>
        <form method="GET" class="mb-3">
            <div class="row g-2 align-items-end">
                <div class="col-md-4">
                    <label for="branch" class="form-label">Filter by Branch</label>
                    <select name="branch" id="branch" class="form-select select2">
                        <option value="0">-- All Branches --</option>
                        <?php foreach ($branches as $b): ?>
                            <option value="<?= $b['id'] ?>" <?= $branch_filter == $b['id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($b['branch_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary w-100"><i class="fas fa-filter"></i> Filter</button>
                </div>
            </div>
        </form>
    <?php endif; ?>

    <div class="card">
        <div class="card-body table-responsive">
            <table class="table table-striped table-bordered" id="vehiclesTable">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Plate No.</th>
                        <th>Make & Model</th>
                        <th>Fuel</th>
                        <th>Odometer (km)</th>
                        <th>Status</th>
                        <th>Driver</th>
                        <th>Branch</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $sn = 1; while ($row = $vehicles->fetch_assoc()): ?>
                        <tr>
                            <td><?= $sn++ ?></td>
                            <td><strong><?= htmlspecialchars($row['plate_number']) ?></strong></td>
                            <td><?= htmlspecialchars($row['make'] . ' ' . $row['model']) ?></td>
                            <td><?= htmlspecialchars($row['fuel_type']) ?></td>
                            <td><?= number_format($row['odometer'], 1) ?></td>
                            <td>
                                <?php
                                $status = $row['status'];
                                $badge = match ($status) {
                                    'Active' => 'success',
                                    'Maintenance' => 'warning',
                                    'Inactive' => 'secondary',
                                    default => 'light'
                                };
                                ?>
                                <span class="badge bg-<?= $badge ?>"><?= $status ?></span>
                            </td>
                            <td><?= $row['driver_name'] ? htmlspecialchars($row['driver_name']) : '<em>Unassigned</em>' ?></td>
                            <td><?= htmlspecialchars($row['branch_name'] ?? '-') ?></td>
                            <td class="text-nowrap">
                                <a href="view_vehicle.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info" title="View">
                                    <i class="fas fa-eye"></i>
                                </a>
                                <a href="assign_driver.php?vehicle_id=<?= $row['id'] ?>" class="btn btn-sm btn-warning" title="Assign Driver">
                                    <i class="fas fa-user-tag"></i>
                                </a>
                                <a href="add_trip.php?vehicle_id=<?= $row['id'] ?>" class="btn btn-sm btn-secondary" title="Add Trip">
                                    <i class="fas fa-road"></i>
                                </a>
                                <a href="add_fuel.php?vehicle_id=<?= $row['id'] ?>" class="btn btn-sm btn-dark" title="Add Fuel">
                                    <i class="fas fa-gas-pump"></i>
                                </a>
                                <a href="add_maintenance.php?vehicle_id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" title="Log Maintenance">
                                    <i class="fas fa-tools"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include_once __DIR__ . '/../../includes/footer.php'; ?>

<!-- JS + DataTables + Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#vehiclesTable').DataTable({
            pageLength: 10,
            order: [[1, 'asc']]
        });
        $('.select2').select2();
    });
</script>
