<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;
$branch_filter = isset($_GET['branch']) ? intval($_GET['branch']) : 0;

// Fetch branches for admin filter
$branches = [];
if ($current_role === 'Admin') {
    $res = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name");
    while ($row = $res->fetch_assoc()) {
        $branches[] = $row;
    }
}

// Fetch maintenance logs
$query = "
SELECT m.*, v.plate_number, v.make, v.model, b.branch_name
FROM maintenance_logs m
JOIN vehicles v ON m.vehicle_id = v.id
LEFT JOIN branches b ON v.branch_id = b.id
WHERE 1=1
";

if ($current_role !== 'Admin') {
    $query .= " AND v.branch_id = $current_branch";
} elseif ($branch_filter > 0) {
    $query .= " AND v.branch_id = $branch_filter";
}

$query .= " ORDER BY m.maintenance_date DESC";
$result = $conn->query($query);

include_once '../../includes/layout2.php';
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary"><i class="fas fa-tools me-2"></i> Maintenance Logs</h4>
        <a href="add_maintenance.php" class="btn btn-success"><i class="fas fa-plus-circle me-1"></i> Add Maintenance</a>
    </div>

    <!-- Filters -->
    <?php if ($current_role === 'Admin'): ?>
        <form class="row g-2 align-items-end mb-3" method="GET">
            <div class="col-md-4">
                <label for="branch" class="form-label">Filter by Branch</label>
                <select name="branch" id="branch" class="form-select select2">
                    <option value="0">-- All Branches --</option>
                    <?php foreach ($branches as $b): ?>
                        <option value="<?= $b['id'] ?>" <?= $b['id'] == $branch_filter ? 'selected' : '' ?>>
                            <?= htmlspecialchars($b['branch_name']) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-2">
                <button type="submit" class="btn btn-primary w-100"><i class="fas fa-filter"></i> Filter</button>
            </div>
        </form>
    <?php endif; ?>

    <!-- Alerts -->
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success']; unset($_SESSION['success']); ?></div>
    <?php elseif (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-bordered table-striped" id="maintenanceTable">
                <thead class="table-light">
                    <tr>
                        <th>#</th>
                        <th>Date</th>
                        <th>Vehicle</th>
                        <th>Service Type</th>
                        <th>Garage</th>
                        <th>Odometer (km)</th>
                        <th>Cost</th>
                        <th>Remarks</th>
                        <th>Branch</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($result): $sn = 1; while ($row = $result->fetch_assoc()): ?>
                        <tr>
                            <td><?= $sn++ ?></td>
                            <td><?= htmlspecialchars($row['maintenance_date']) ?></td>
                            <td>
                                <strong><?= htmlspecialchars($row['plate_number']) ?></strong><br>
                                <small><?= htmlspecialchars($row['make'] . ' ' . $row['model']) ?></small>
                            </td>
                            <td><?= htmlspecialchars($row['service_type']) ?></td>
                            <td><?= htmlspecialchars($row['garage_name']) ?></td>
                            <td><?= number_format($row['odometer'], 1) ?></td>
                            <td>KES <?= number_format($row['cost'], 2) ?></td>
                            <td><?= nl2br(htmlspecialchars($row['remarks'])) ?></td>
                            <td><?= htmlspecialchars($row['branch_name']) ?></td>
                        </tr>
                    <?php endwhile; else: ?>
                        <tr><td colspan="9" class="text-center text-muted">No maintenance logs found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include_once '../../includes/footer.php'; ?>

<!-- Scripts -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        $('#maintenanceTable').DataTable({ pageLength: 10 });
        $('.select2').select2();
    });
</script>
