<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header("Location: list_vehicles.php");
    exit();
}

// CSRF check
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION['error'] = "Invalid request token.";
    header("Location: add_vehicle.php");
    exit();
}

// Sanitize input
$vehicle_id     = intval($_POST['vehicle_id']);
$plate_number   = strtoupper(trim($_POST['plate_number']));
$make           = trim($_POST['make']);
$model          = trim($_POST['model']);
$year           = intval($_POST['year']);
$fuel_type      = $_POST['fuel_type'];
$tank_capacity  = floatval($_POST['tank_capacity']);
$odometer       = floatval($_POST['odometer']);
$status         = $_POST['status'];
$branch_id      = intval($_POST['branch_id']);

// Validate required fields
if (empty($plate_number) || empty($make) || empty($model) || !$year || empty($fuel_type) || empty($status) || !$branch_id) {
    $_SESSION['error'] = "Please fill in all required fields.";
    header("Location: add_vehicle.php?id=$vehicle_id");
    exit();
}

// Prevent duplicate plate number
if ($vehicle_id == 0) {
    $stmt = $conn->prepare("SELECT id FROM vehicles WHERE plate_number = ?");
    $stmt->bind_param("s", $plate_number);
    $stmt->execute();
    $res = $stmt->get_result();
    if ($res->num_rows > 0) {
        $_SESSION['error'] = "Vehicle with this plate number already exists.";
        header("Location: add_vehicle.php");
        exit();
    }
    $stmt->close();
}

if ($vehicle_id > 0) {
    // UPDATE
    $stmt = $conn->prepare("UPDATE vehicles SET plate_number=?, make=?, model=?, year=?, fuel_type=?, tank_capacity=?, odometer=?, status=?, branch_id=? WHERE id=?");
    $stmt->bind_param("sssisdssii", $plate_number, $make, $model, $year, $fuel_type, $tank_capacity, $odometer, $status, $branch_id, $vehicle_id);
    if ($stmt->execute()) {
        $_SESSION['success'] = "Vehicle updated successfully.";
    } else {
        $_SESSION['error'] = "Error updating vehicle.";
    }
    $stmt->close();
} else {
    // INSERT
    $stmt = $conn->prepare("INSERT INTO vehicles (plate_number, make, model, year, fuel_type, tank_capacity, odometer, status, branch_id, created_at)
                            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW())");
    $stmt->bind_param("sssisdssi", $plate_number, $make, $model, $year, $fuel_type, $tank_capacity, $odometer, $status, $branch_id);
    if ($stmt->execute()) {
        $_SESSION['success'] = "Vehicle added successfully.";
    } else {
        $_SESSION['error'] = "Error saving vehicle.";
    }
    $stmt->close();
}

header("Location: list_vehicles.php");
exit();
