<?php
session_start();
require_once '../../config/db.php';

if (!isset($_GET['action'], $_GET['id'])) {
  $_SESSION['error'] = "Missing action or invoice ID.";
  header("Location: list.php");
  exit;
}

$action = $_GET['action'];
$invoice_id = (int) $_GET['id'];
$user_id = $_SESSION['user_id'] ?? 0;
$user_role = $_SESSION['role'] ?? '';

// Step 1: Verify invoice exists
$stmt = $conn->prepare("SELECT status FROM invoices WHERE id = ?");
$stmt->bind_param("i", $invoice_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
  $_SESSION['error'] = "Invoice not found.";
  header("Location: list.php");
  exit;
}

$row = $result->fetch_assoc();

// Step 2: Only Admins or Managers can approve
if (!in_array($user_role, ['Admin', 'Manager'])) {
  $_SESSION['error'] = "You do not have permission to approve invoices.";
  header("Location: view.php?id=$invoice_id");
  exit;
}

// Step 3: Only approve if current status is Verified
if ($action === 'approve' && $row['status'] === 'Verified') {

  // Step 4: Perform update with audit tracking
  $update = $conn->prepare("
    UPDATE invoices 
    SET status = 'Approved', approved_by = ?, approved_at = NOW()
    WHERE id = ?
  ");
  $update->bind_param("ii", $user_id, $invoice_id);

  if ($update->execute()) {
    $_SESSION['success'] = "✅ Invoice approved successfully.";

    // Optional: Insert audit log
    $log = $conn->prepare("
      INSERT INTO invoice_logs (invoice_id, user_id, action, timestamp)
      VALUES (?, ?, 'Approved', NOW())
    ");
    $log->bind_param("ii", $invoice_id, $user_id);
    $log->execute();

  } else {
    $_SESSION['error'] = "❌ Failed to approve invoice.";
  }

} else {
  $_SESSION['error'] = "This invoice cannot be approved in its current state.";
}

header("Location: view.php?id=$invoice_id");
exit;
<?php include '../../includes/footer.php'; ?>
