<?php
session_start();
require_once '../../config/db.php';

$invoice_id = isset($_GET['id']) ? (int) $_GET['id'] : 0;
if (!$invoice_id) {
  die("Invalid invoice ID.");
}

// Fetch invoice
$stmt = $conn->prepare("SELECT file_path FROM invoices WHERE id = ?");
$stmt->bind_param("i", $invoice_id);
$stmt->execute();
$stmt->bind_result($file_path);
$stmt->fetch();
$stmt->close();

if (!$file_path) {
  die("Invoice file not found.");
}

// Build full path
$full_path = realpath("../../assets/uploads/invoices/" . $file_path);

// Security check: Make sure it's within your upload folder
$base_dir = realpath("../../assets/uploads/invoices/");
if (strpos($full_path, $base_dir) !== 0 || !file_exists($full_path)) {
  die("Access denied or file missing.");
}

// Force file download
header("Content-Type: application/pdf");
header("Content-Disposition: attachment; filename=\"" . basename($file_path) . "\"");
header("Content-Length: " . filesize($full_path));
readfile($full_path);
exit;
