<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (!isset($_GET['id'])) {
  $_SESSION['error'] = "Invoice not specified.";
  header("Location: list.php");
  exit;
}

$id = (int) $_GET['id'];
$invoice = $conn->query("SELECT * FROM invoices WHERE id = $id")->fetch_assoc();

if (!$invoice) {
  $_SESSION['error'] = "Invoice not found.";
  header("Location: list.php");
  exit;
}

if (empty($_SESSION['csrf_token'])) {
  $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name ASC");
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-edit"></i> Edit Invoice</h4>

  <form action="update_invoice.php" method="POST" enctype="multipart/form-data" class="card p-4 shadow-sm bg-white">
    <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
    <input type="hidden" name="id" value="<?= $invoice['id'] ?>">

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Supplier</label>
        <select name="supplier_id" class="form-select" required>
          <?php while ($s = $suppliers->fetch_assoc()): ?>
            <option value="<?= $s['id'] ?>" <?= $s['id'] == $invoice['supplier_id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($s['name']) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label">Branch</label>
        <select name="branch_id" class="form-select" required>
          <?php while ($b = $branches->fetch_assoc()): ?>
            <option value="<?= $b['id'] ?>" <?= $b['id'] == $invoice['branch_id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($b['branch_name']) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>

      <div class="col-md-4">
        <label class="form-label">Invoice Date</label>
        <input type="date" name="invoice_date" class="form-control" required value="<?= $invoice['invoice_date'] ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Invoice Number</label>
        <input type="text" name="invoice_number" class="form-control" value="<?= htmlspecialchars($invoice['invoice_number']) ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Total Invoice Amount</label>
        <input type="number" step="0.01" name="total_invoice_amount" class="form-control" value="<?= $invoice['total_amount'] ?>" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Zero-Rated Amount</label>
        <input type="number" step="0.01" name="zero_rated_amount" class="form-control" value="<?= $invoice['zero_rated_amount'] ?>">
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Replace Invoice File (PDF)</label>
        <input type="file" name="invoice_file" class="form-control" accept=".pdf">
        <small class="text-muted">Leave blank to keep current file</small>
      </div>
      <div class="col-md-6">
        <label class="form-label">VAT Type</label><br>
        <div class="form-check form-check-inline">
          <input class="form-check-input" type="radio" name="vat_inclusion" value="inclusive"
            <?= $invoice['vat_type'] === 'inclusive' ? 'checked' : '' ?>>
          <label class="form-check-label">Inclusive</label>
        </div>
        <div class="form-check form-check-inline">
          <input class="form-check-input" type="radio" name="vat_inclusion" value="exclusive"
            <?= $invoice['vat_type'] === 'exclusive' ? 'checked' : '' ?>>
          <label class="form-check-label">Exclusive</label>
        </div>
      </div>
    </div>

    <!-- Totals -->
    <input type="hidden" name="vatable_amount" value="<?= $invoice['vatable_amount'] ?>">
    <input type="hidden" name="vat_amount" value="<?= $invoice['vat_amount'] ?>">
    <input type="hidden" name="withholding_tax" value="<?= $invoice['withholding_tax'] ?>">
    <input type="hidden" name="total_payable" value="<?= $invoice['total_payable'] ?>">
    <input type="hidden" name="total_with_vat" value="<?= $invoice['total_with_vat'] ?>">

    <div class="text-end">
      <button type="submit" class="btn btn-success"><i class="fas fa-save me-1"></i> Update Invoice</button>
    </div>
  </form>
</div>
<?php include '../../includes/footer.php'; ?>