<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$user_role = $_SESSION['role'] ?? '';

// Load filter data
$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name ASC");
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");
if (!$suppliers || !$branches) {
  die("<div class='alert alert-danger'>Failed to load filters: " . $conn->error . "</div>");
}

// Filters
$supplier_id = (int)($_GET['supplier_id'] ?? 0);
$branch_id = (int)($_GET['branch_id'] ?? 0);
$search_term = trim($_GET['search'] ?? '');
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

$where = [];
if ($supplier_id) $where[] = "i.supplier_id = $supplier_id";
if ($branch_id) $where[] = "i.branch_id = $branch_id";
if ($search_term) {
  $term = $conn->real_escape_string($search_term);
  $where[] = "(i.invoice_number LIKE '%$term%' OR s.name LIKE '%$term%')";
}
if ($from_date && $to_date) {
  $where[] = "DATE(i.invoice_date) BETWEEN '$from_date' AND '$to_date'";
}
$filter_sql = count($where) ? 'WHERE ' . implode(' AND ', $where) : '';

// Invoice query
$query = "
  SELECT i.*, s.name AS supplier_name, b.branch_name
  FROM invoices i
  JOIN suppliers s ON i.supplier_id = s.id
  JOIN branches b ON i.branch_id = b.id
  $filter_sql
  ORDER BY i.created_at DESC
";
$result = $conn->query($query);
if (!$result) {
  die("<div class='alert alert-danger'>Error loading invoices: " . $conn->error . "</div>");
}

// Dashboard stats
$stats = ['total' => 0, 'submitted' => 0, 'verified' => 0, 'approved_unpaid' => 0, 'paid' => 0];
$stat_conditions = [];
if ($supplier_id) $stat_conditions[] = "supplier_id = $supplier_id";
if ($branch_id) $stat_conditions[] = "branch_id = $branch_id";
if ($from_date && $to_date) $stat_conditions[] = "DATE(invoice_date) BETWEEN '$from_date' AND '$to_date'";
if ($search_term) $stat_conditions[] = "(invoice_number LIKE '%$term%' OR supplier_id IN (SELECT id FROM suppliers WHERE name LIKE '%$term%'))";

$stat_sql = "SELECT status, COUNT(*) AS count FROM invoices";
if ($stat_conditions) $stat_sql .= " WHERE " . implode(' AND ', $stat_conditions);
$stat_sql .= " GROUP BY status";
$stat_res = $conn->query($stat_sql);
if ($stat_res) {
  while ($r = $stat_res->fetch_assoc()) {
    $status = strtolower($r['status']);
    $stats['total'] += $r['count'];
    if ($status === 'submitted') $stats['submitted'] = $r['count'];
    if ($status === 'verified') $stats['verified'] = $r['count'];
    if ($status === 'approved') $stats['approved_unpaid'] = $r['count'];
    if ($status === 'paid') $stats['paid'] = $r['count'];
  }
}

// Smart AI-like summary
$this_week_start = date('Y-m-d', strtotime('monday this week'));
$this_week_end = date('Y-m-d');
$summary_res = $conn->query("
  SELECT 
    COUNT(*) AS total_this_week,
    SUM(CASE WHEN status IN ('Submitted', 'Verified') THEN 1 ELSE 0 END) AS pending_approval,
    SUM(CASE WHEN status != 'Paid' AND due_date < CURDATE() THEN 1 ELSE 0 END) AS overdue
  FROM invoices
  WHERE invoice_date BETWEEN '$this_week_start' AND '$this_week_end'
");
$summary = $summary_res->fetch_assoc();
?>

<div class="main-content">

  <!-- Header -->
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary"><i class="fas fa-list me-2"></i> Supplier Invoices</h4>
    <a href="add.php" class="btn btn-primary"><i class="fas fa-plus-circle me-1"></i> Add Invoice</a>
  </div>

  <!-- Smart Summary Panel -->
  <div class="alert alert-light border-start border-4 border-warning shadow-sm mb-3">
    <i class="fas fa-lightbulb me-2 text-warning"></i>
    <strong>Smart Insight:</strong>
    This week, <strong><?= $summary['total_this_week'] ?></strong> invoices were created.
    <?= $summary['pending_approval'] ?> are still <strong>pending approval</strong>,
    and <?= $summary['overdue'] ?> are <strong>overdue</strong> (past due & unpaid).
  </div>

  <!-- Mini Dashboard -->
  <div class="row g-3 mb-4">
    <div class="col-md-2"><div class="card text-center border-primary"><div class="card-body"><strong>Total</strong><h5><?= $stats['total'] ?></h5></div></div></div>
    <div class="col-md-2"><div class="card text-center border-info"><div class="card-body"><strong>Submitted</strong><h5><?= $stats['submitted'] ?></h5></div></div></div>
    <div class="col-md-2"><div class="card text-center border-warning"><div class="card-body"><strong>Verified</strong><h5><?= $stats['verified'] ?></h5></div></div></div>
    <div class="col-md-3"><div class="card text-center border-success"><div class="card-body"><strong>Approved (Unpaid)</strong><h5><?= $stats['approved_unpaid'] ?></h5></div></div></div>
    <div class="col-md-3"><div class="card text-center border-dark"><div class="card-body"><strong>Paid</strong><h5><?= $stats['paid'] ?></h5></div></div></div>
  </div>

  <!-- Filters -->
  <form class="row g-3 mb-4" method="GET">
    <div class="col-md-3">
      <label class="form-label">Supplier</label>
      <select name="supplier_id" class="form-select">
        <option value="">-- All --</option>
        <?php $suppliers->data_seek(0); while ($s = $suppliers->fetch_assoc()): ?>
          <option value="<?= $s['id'] ?>" <?= $supplier_id == $s['id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($s['name']) ?>
          </option>
        <?php endwhile; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Branch</label>
      <select name="branch_id" class="form-select">
        <option value="">-- All --</option>
        <?php $branches->data_seek(0); while ($b = $branches->fetch_assoc()): ?>
          <option value="<?= $b['id'] ?>" <?= $branch_id == $b['id'] ? 'selected' : '' ?>>
            <?= htmlspecialchars($b['branch_name']) ?>
          </option>
        <?php endwhile; ?>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label">Search</label>
      <input type="text" name="search" class="form-control" placeholder="Invoice No or Supplier" value="<?= htmlspecialchars($search_term) ?>">
    </div>
    <div class="col-md-3 d-flex align-items-end">
      <div class="input-group">
        <input type="date" name="from_date" class="form-control" value="<?= $from_date ?>">
        <input type="date" name="to_date" class="form-control" value="<?= $to_date ?>">
        <button class="btn btn-dark" type="submit"><i class="fas fa-filter"></i></button>
      </div>
    </div>
  </form>

  <!-- Alerts -->
  <?php if (isset($_SESSION['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show"><?= $_SESSION['success'] ?><button class="btn-close" data-bs-dismiss="alert"></button></div>
    <?php unset($_SESSION['success']); endif; ?>
  <?php if (isset($_SESSION['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show"><?= $_SESSION['error'] ?><button class="btn-close" data-bs-dismiss="alert"></button></div>
    <?php unset($_SESSION['error']); endif; ?>

  <!-- Invoice Table -->
  <div class="card border-0 shadow-sm">
    <div class="card-body table-responsive">
      <table class="table table-bordered table-hover align-middle small">
        <thead class="table-dark text-center">
          <tr><th>#</th><th>Supplier</th><th>Branch</th><th>Invoice No</th><th>Date</th><th>Total</th><th>Status</th><th width="250">Actions</th></tr>
        </thead>
        <tbody>
        <?php if ($result->num_rows > 0): $count = 1; while ($row = $result->fetch_assoc()):
          $is_late = (date('Y-m-d', strtotime($row['invoice_date'])) !== date('Y-m-d', strtotime($row['created_at'])));
        ?>
          <tr class="<?= $is_late ? 'table-warning' : '' ?>">
            <td class="text-center"><?= $count++ ?></td>
            <td><?= htmlspecialchars($row['supplier_name']) ?></td>
            <td><?= htmlspecialchars($row['branch_name']) ?></td>
            <td><?= htmlspecialchars($row['invoice_number']) ?></td>
            <td><?= date('d-M-Y', strtotime($row['invoice_date'])) ?></td>
            <td class="text-end">KSh <?= number_format($row['total_payable'], 2) ?></td>
            <td class="text-center">
              <?php
              $badge = match ($row['status']) {
                'Draft' => 'bg-secondary',
                'Submitted' => 'bg-info text-dark',
                'Verified' => 'bg-warning text-dark',
                'Approved' => 'bg-success',
                'Paid' => 'bg-primary',
                default => 'bg-light text-dark'
              };
              ?>
              <span class="badge <?= $badge ?> px-3"><?= $row['status'] ?></span>
              <?php if ($is_late): ?>
                <span class="badge bg-danger ms-2" title="Invoice entered late">⚠️ Late</span>
              <?php endif; ?>
            </td>
            <td class="text-center">
              <a href="view.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-primary me-1"><i class="fas fa-eye"></i></a>
              <a href="edit_invoice.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-success me-1"><i class="fas fa-edit"></i></a>
              <a href="download_pdf.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-secondary me-1"><i class="fas fa-file-pdf"></i></a>

              <?php if ($row['status'] === 'Draft' && in_array($user_role, ['Admin', 'Accountant'])): ?>
                <button class="btn btn-sm btn-outline-dark me-1" onclick="openPasswordModal('submit', <?= $row['id'] ?>)">Submit</button>
              <?php elseif ($row['status'] === 'Submitted' && in_array($user_role, ['Admin', 'Manager'])): ?>
                <button class="btn btn-sm btn-outline-warning me-1" onclick="openPasswordModal('verify', <?= $row['id'] ?>)">Verify</button>
              <?php elseif ($row['status'] === 'Verified' && in_array($user_role, ['Admin', 'Manager'])): ?>
                <button class="btn btn-sm btn-outline-success me-1" onclick="openPasswordModal('approve', <?= $row['id'] ?>)">Approve</button>
              <?php endif; ?>
            </td>
          </tr>
        <?php endwhile; else: ?>
          <tr><td colspan="8" class="text-center text-muted py-4">No matching invoices found.</td></tr>
        <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="passwordModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="POST" action="transition_invoice.php" class="modal-content">
      <input type="hidden" name="action" id="modal_action">
      <input type="hidden" name="invoice_id" id="modal_invoice_id">
      <div class="modal-header bg-dark text-white">
        <h5 class="modal-title"><i class="fas fa-key me-2"></i>Confirm Action</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <p>Please enter your password to continue.</p>
        <input type="password" name="password" class="form-control" required placeholder="Password">
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" type="submit">Confirm</button>
        <button class="btn btn-secondary" type="button" data-bs-dismiss="modal">Cancel</button>
      </div>
    </form>
  </div>
</div>

<script>
function openPasswordModal(action, invoiceId) {
  document.getElementById('modal_action').value = action;
  document.getElementById('modal_invoice_id').value = invoiceId;
  new bootstrap.Modal(document.getElementById('passwordModal')).show();
}
</script>

<?php include '../../includes/footer.php'; ?>
