<?php
session_start();
require_once '../../config/db.php';

if (!isset($_GET['action'], $_GET['id'])) {
  $_SESSION['error'] = "Missing action or invoice ID.";
  header("Location: list.php");
  exit;
}

$action = $_GET['action'];
$invoice_id = (int) $_GET['id'];

// Fetch current status
$stmt = $conn->prepare("SELECT status FROM invoices WHERE id = ?");
$stmt->bind_param("i", $invoice_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
  $_SESSION['error'] = "Invoice not found.";
  header("Location: list.php");
  exit;
}
$row = $result->fetch_assoc();

// Transition Logic
$new_status = null;
$success_msg = "";
$allowed = false;

switch ($action) {
  case 'submit':
    if ($row['status'] === 'Draft') {
      $new_status = 'Submitted';
      $success_msg = "Invoice submitted for verification.";
      $allowed = true;
    }
    break;

  case 'verify':
    if ($row['status'] === 'Submitted') {
      $new_status = 'Verified';
      $success_msg = "Invoice verified successfully.";
      $allowed = true;
    }
    break;

  default:
    $_SESSION['error'] = "Invalid action.";
    header("Location: list.php");
    exit;
}

if (!$allowed) {
  $_SESSION['error'] = "This action is not allowed in the current invoice state.";
  header("Location: view.php?id=$invoice_id");
  exit;
}

// Perform update
$update = $conn->prepare("UPDATE invoices SET status = ? WHERE id = ?");
$update->bind_param("si", $new_status, $invoice_id);

if ($update->execute()) {
  $_SESSION['success'] = "✅ $success_msg";
} else {
  $_SESSION['error'] = "Failed to update invoice status.";
}

header("Location: view.php?id=$invoice_id");
exit;
