<?php
require_once '../../config/db.php';

$branch_id = $_GET['branch_id'] ?? '';
$date = $_GET['date'] ?? date('Y-m-d');

if (!$branch_id) {
  exit("❌ Branch not selected.");
}

// Fetch branch name
$branch_stmt = $conn->prepare("SELECT branch_name FROM branches WHERE id = ?");
$branch_stmt->bind_param("i", $branch_id);
$branch_stmt->execute();
$branch_result = $branch_stmt->get_result();
$branch_name = $branch_result->fetch_assoc()['branch_name'] ?? 'Unknown Branch';

// Fetch merchandiser logs
$stmt = $conn->prepare("
  SELECT l.*, m.full_name, m.id_number, s.name AS supplier_name 
  FROM merchandiser_logs l
  JOIN merchandisers m ON l.merchandiser_id = m.id
  JOIN suppliers s ON m.supplier_id = s.id
  WHERE l.branch_id = ? AND DATE(l.log_time) = ?
  ORDER BY l.log_time ASC
");
$stmt->bind_param("is", $branch_id, $date);
$stmt->execute();
$logs = $stmt->get_result();
?>

<!DOCTYPE html>
<html>
<head>
  <title>Merchandiser Log Summary - <?= htmlspecialchars($branch_name) ?></title>
  <link href="../../assets/bootstrap.min.css" rel="stylesheet">
  <style>
    body { font-family: Arial, sans-serif; margin: 30px; }
    .summary-header h4, .summary-header h5 {
      margin: 0;
      padding: 0;
    }
    @media print {
      body { margin: 0; }
      .no-print { display: none; }
    }
  </style>
</head>
<body onload="window.print();">

  <div class="summary-header text-center mb-4">
    <h4 class="fw-bold">🛡 Merchandiser Daily Log Summary</h4>
    <h5><?= htmlspecialchars($branch_name) ?> — <?= date('d M Y', strtotime($date)) ?></h5>
  </div>

  <table class="table table-bordered table-striped align-middle">
    <thead class="table-dark">
      <tr>
        <th>#</th>
        <th>Name</th>
        <th>ID Number</th>
        <th>Supplier</th>
        <th>Log Type</th>
        <th>Time</th>
      </tr>
    </thead>
    <tbody>
      <?php $i = 1; while ($log = $logs->fetch_assoc()): ?>
        <tr>
          <td><?= $i++ ?></td>
          <td><?= htmlspecialchars($log['full_name']) ?></td>
          <td><?= htmlspecialchars($log['id_number']) ?></td>
          <td><?= htmlspecialchars($log['supplier_name']) ?></td>
          <td>
            <span class="badge bg-<?= $log['log_type'] === 'IN' ? 'success' : 'danger' ?>">
              <?= $log['log_type'] ?>
            </span>
          </td>
          <td><?= date('H:i:s', strtotime($log['log_time'])) ?></td>
        </tr>
      <?php endwhile; ?>
      <?php if ($logs->num_rows === 0): ?>
        <tr>
          <td colspan="6" class="text-center text-muted">No records found for this date.</td>
        </tr>
      <?php endif; ?>
    </tbody>
  </table>

  <div class="text-end mt-4 no-print">
    <a href="javascript:window.close();" class="btn btn-secondary">Close</a>
  </div>
</body>
</html>
