<?php
session_start();
require_once '../../config/db.php';

$id_number = trim($_POST['id_number'] ?? '');
$branch_id = (int)($_POST['branch_id'] ?? 0);
$log_type = $_POST['log_type'] ?? '';
$csrf_token = $_POST['csrf_token'] ?? '';

if (!$id_number || !$branch_id || !$log_type || $csrf_token !== $_SESSION['csrf_token']) {
    $_SESSION['merch_msg'] = "Invalid submission. Please try again.";
    header("Location: merch_login.php");
    exit;
}

// Get merchandiser
$stmt = $conn->prepare("SELECT * FROM merchandisers WHERE id_number = ? AND status = 'Active'");
$stmt->bind_param("s", $id_number);
$stmt->execute();
$merch = $stmt->get_result()->fetch_assoc();

if (!$merch) {
    $_SESSION['merch_msg'] = "Merchandiser not found or inactive.";
    header("Location: merch_login.php");
    exit;
}

// Check last log
$stmt = $conn->prepare("SELECT log_type FROM merchandiser_logs WHERE merchandiser_id = ? ORDER BY log_time DESC LIMIT 1");
$stmt->bind_param("i", $merch['id']);
$stmt->execute();
$last = $stmt->get_result()->fetch_assoc();

if ($log_type === 'IN' && $last && $last['log_type'] === 'IN') {
    $_SESSION['merch_msg'] = "Already logged in. Please log out first.";
    header("Location: merch_login.php");
    exit;
}

if ($log_type === 'OUT' && (!$last || $last['log_type'] !== 'IN')) {
    $_SESSION['merch_msg'] = "You must log in before logging out.";
    header("Location: merch_login.php");
    exit;
}

// Insert log
$stmt = $conn->prepare("INSERT INTO merchandiser_logs (merchandiser_id, branch_id, log_type, log_time) VALUES (?, ?, ?, NOW())");
$stmt->bind_param("iis", $merch['id'], $branch_id, $log_type);
$stmt->execute();
$log_id = $conn->insert_id;

// Redirect logic
if ($log_type === 'IN') {
    $_SESSION['merch_msg'] = 'Logged in successfully!';
    header("Location: merch_login.php?badge=$log_id");
} else {
    $_SESSION['merch_msg'] = 'Logged out successfully!';
    header("Location: merch_login.php?badge=$log_id");  // if you want badge on logout, keep ?badge, else remove it
}
exit;
