<?php
session_start();
require_once __DIR__ . '/../../config/db.php';
include __DIR__ . '/../../includes/layout2.php';

$customers = $conn->query("SELECT id, name FROM newspaper_customers ORDER BY name");
$titles = $conn->query("SELECT id, title FROM newspaper_titles ORDER BY title");
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-truck"></i> Add Newspaper Dispatch</h4>

  <form method="POST" action="save_dispatch.php" class="card p-4 shadow-sm bg-white">
    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Date</label>
        <input type="date" name="date" class="form-control" required value="<?= date('Y-m-d') ?>">
      </div>
      <div class="col-md-4">
        <label class="form-label">Customer</label>
        <select name="customer_id" class="form-select" required>
          <option value="">-- Select Customer --</option>
          <?php while ($c = $customers->fetch_assoc()): ?>
          <option value="<?= $c['id'] ?>"><?= htmlspecialchars($c['name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-4">
        <label class="form-label">Newspaper</label>
        <select name="newspaper_id" class="form-select" required>
          <option value="">-- Select Newspaper --</option>
          <?php while ($n = $titles->fetch_assoc()): ?>
          <option value="<?= $n['id'] ?>"><?= htmlspecialchars($n['title']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Quantity</label>
        <input type="number" name="quantity" class="form-control" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Collected By</label>
        <input type="text" name="collected_by" class="form-control">
      </div>
      <div class="col-md-4">
        <label class="form-label">Remarks</label>
        <input type="text" name="remarks" class="form-control">
      </div>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Dispatch</button>
    </div>
  </form>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
