<?php
session_start();
require_once __DIR__ . '/../../config/db.php';
include __DIR__ . '/../../includes/layout2.php';

$query = "SELECT * FROM newspaper_customers ORDER BY name";
$result = $conn->query($query);
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-users"></i> Newspaper Customers</h4>

  <a href="add_customer.php" class="btn btn-success mb-3"><i class="fas fa-plus-circle me-1"></i> Add New Customer</a>

  <div class="card shadow-sm">
    <div class="card-body table-responsive">
      <table class="table table-bordered table-striped">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>Type</th>
            <th>Contact</th>
            <th>Pickup Time</th>
            <th>Branch</th>
          </tr>
        </thead>
        <tbody>
          <?php $i = 1; while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= $i++ ?></td>
            <td><?= htmlspecialchars($row['name']) ?></td>
            <td><?= htmlspecialchars($row['type']) ?></td>
            <td><?= htmlspecialchars($row['contact']) ?></td>
            <td><?= htmlspecialchars($row['usual_pickup_time']) ?></td>
            <td><?= htmlspecialchars($row['branch_id']) ?></td>
          </tr>
          <?php endwhile; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
