<?php
session_start();
include '../../includes/layout2.php';
?>

<!DOCTYPE html>
<html>
<head>
  <title>SmartPay360 | Payment Calendar</title>
  <link href="https://cdn.jsdelivr.net/npm/fullcalendar@6/index.global.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6/index.global.min.js"></script>
  <style>
    body { background: #f4f4f4; font-family: 'Segoe UI'; }
    #calendar { max-width: 1100px; margin: 40px auto; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 8px rgba(0,0,0,0.1); }
  </style>
</head>
<body>
<div class="container">
  <h3 class="mt-4 mb-3 text-center text-primary">💳 Payment Calendar</h3>
  <div id="calendar"></div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
  const calendar = new FullCalendar.Calendar(document.getElementById('calendar'), {
    initialView: 'dayGridMonth',
    headerToolbar: {
      left: 'prev,next today',
      center: 'title',
      right: 'dayGridMonth,listWeek'
    },
    events: '/smartpay360/modules/payments/payment_calendar_data.php',
    eventClick: function (info) {
      const props = info.event.extendedProps;
      alert(
        `Reference: ${props.reference_no}\n` +
        `Amount: KSh ${props.amount}\n` +
        `Method: ${props.method}\n` +
        `Supplier: ${props.supplier}`
      );
    }
  });
  calendar.render();
});
</script>
</body>
</html>
