<?php
require_once '../../config/db.php';
header('Content-Type: application/json');

$sql = "
  SELECT p.id, p.reference_no, p.amount, p.payment_date, p.method, p.remarks, s.name AS supplier
  FROM payments p
  JOIN suppliers s ON p.supplier_id = s.id
  WHERE p.payment_date IS NOT NULL
";

$result = $conn->query($sql);
$events = [];

while ($row = $result->fetch_assoc()) {
  $color = match (strtolower($row['method'])) {
    'mpesa' => '#007bff',
    'cash' => '#28a745',
    'cheque' => '#dc3545',
    'visa', 'card' => '#17a2b8',
    default => '#6c757d'
  };

  $events[] = [
    'title' => 'KSh ' . number_format($row['amount'], 2) . ' - ' . ucfirst($row['method']),
    'start' => $row['payment_date'],
    'color' => $color,
    'extendedProps' => [
      'reference_no' => $row['reference_no'],
      'amount' => number_format($row['amount'], 2),
      'method' => $row['method'],
      'remarks' => $row['remarks'],
      'supplier' => $row['supplier']
    ]
  ];
}

echo json_encode($events);
