<?php
require_once '../../config/db.php';

header("Content-Type: text/csv");
header("Content-Disposition: attachment; filename=supplier_payments_" . date("Ymd_His") . ".csv");

// Get filters
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

$conditions = [];
$params = [];
$types = '';

if ($supplier_id > 0) {
    $conditions[] = "p.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= 'i';
}
if (!empty($from_date)) {
    $conditions[] = "p.payment_date >= ?";
    $params[] = $from_date;
    $types .= 's';
}
if (!empty($to_date)) {
    $conditions[] = "p.payment_date <= ?";
    $params[] = $to_date;
    $types .= 's';
}
$where = count($conditions) ? 'WHERE ' . implode(' AND ', $conditions) : '';

// Query
$query = "
    SELECT p.id, s.name AS supplier_name, p.payment_date, p.amount,
    (SELECT GROUP_CONCAT(i.invoice_number ORDER BY i.invoice_number SEPARATOR ', ')
     FROM payment_allocations pa
     JOIN invoices i ON pa.invoice_id = i.id
     WHERE pa.payment_id = p.id) AS invoice_numbers
    FROM payments p
    JOIN suppliers s ON p.supplier_id = s.id
    $where
    ORDER BY p.payment_date DESC
";

$stmt = $conn->prepare($query);
if (count($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

// Output CSV
$output = fopen("php://output", "w");
fputcsv($output, ['#', 'Supplier', 'Payment Date', 'Amount', 'Invoice No(s)']);

$i = 1;
while ($row = $result->fetch_assoc()) {
    fputcsv($output, [
        $i++,
        $row['supplier_name'],
        $row['payment_date'],
        $row['amount'],
        $row['invoice_numbers'] ?: 'None'
    ]);
}

fclose($output);
exit;
