<?php
session_start();
require_once '../../config/db.php';
require_once '../../vendor/fpdf/fpdf.php'; // Adjust path if needed

$payment_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($payment_id <= 0) {
    $_SESSION['error'] = 'Invalid payment ID.';
    header('Location: list.php');
    exit;
}

$query = "
    SELECT p.id, p.supplier_id, s.name AS supplier_name, 
           p.amount, p.payment_date, p.reference_no, p.method, p.remarks,
           (SELECT GROUP_CONCAT(i.invoice_number ORDER BY i.invoice_number SEPARATOR ', ') 
            FROM payment_allocations pa 
            JOIN invoices i ON pa.invoice_id = i.id 
            WHERE pa.payment_id = p.id) AS invoice_numbers
    FROM payments p
    JOIN suppliers s ON p.supplier_id = s.id
    WHERE p.id = ?
";

$stmt = $conn->prepare($query);
$stmt->bind_param('i', $payment_id);
$stmt->execute();
$result = $stmt->get_result();
$payment = $result->fetch_assoc();

if (!$payment) {
    $_SESSION['error'] = 'Payment not found.';
    header('Location: list.php');
    exit;
}

// PDF setup
class PDF extends FPDF {
    function Header() {
        $this->SetFont('Arial', 'B', 14);
        $this->Cell(0, 10, 'Payment Receipt - SmartPay360', 0, 1, 'C');
        $this->Ln(3);
    }
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 12);

$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Payment Details', 0, 1);

$pdf->SetFont('Arial', '', 12);
$pdf->Cell(50, 8, 'Reference No:', 0, 0);
$pdf->Cell(0, 8, $payment['reference_no'], 0, 1);

$pdf->Cell(50, 8, 'Supplier:', 0, 0);
$pdf->Cell(0, 8, $payment['supplier_name'], 0, 1);

$pdf->Cell(50, 8, 'Payment Date:', 0, 0);
$pdf->Cell(0, 8, date('d-M-Y', strtotime($payment['payment_date'])), 0, 1);

$pdf->Cell(50, 8, 'Amount:', 0, 0);
$pdf->Cell(0, 8, 'KSh ' . number_format($payment['amount'], 2), 0, 1);

$pdf->Cell(50, 8, 'Payment Method:', 0, 0);
$pdf->Cell(0, 8, $payment['method'] ?: 'N/A', 0, 1);

$pdf->Cell(50, 8, 'Invoices:', 0, 0);
$pdf->Cell(0, 8, $payment['invoice_numbers'] ?: 'None', 0, 1);

$pdf->Cell(50, 8, 'Remarks:', 0, 0);
$pdf->MultiCell(0, 8, $payment['remarks'] ?: 'N/A');

$pdf->Output('I', 'receipt_' . $payment['reference_no'] . '.pdf');
exit;
