
<?php
session_start();
require_once '../../config/db.php';

// Validate transaction ID
$transaction_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($transaction_id <= 0) {
    $_SESSION['error'] = 'Invalid transaction ID.';
    header('Location: list.php');
    exit;
}

// Fetch transaction details
$query = "
    SELECT pct.id, pct.branch_id, b.branch_name, pct.type, pct.amount, pct.description, 
           pct.reference_no, pct.transaction_date, u.username AS created_by, 
           pct.status, s.name AS supplier_name
    FROM petty_cash_transactions pct
    JOIN branches b ON pct.branch_id = b.id
    JOIN users u ON pct.created_by = u.id
    LEFT JOIN suppliers s ON pct.supplier_id = s.id
    WHERE pct.id = ?
";
$stmt = $conn->prepare($query);
if (!$stmt) {
    error_log('Prepare failed: ' . $conn->error);
    $_SESSION['error'] = 'Database error.';
    header('Location: list.php');
    exit;
}
$stmt->bind_param('i', $transaction_id);
$stmt->execute();
$result = $stmt->get_result();
$transaction = $result->fetch_assoc();

if (!$transaction) {
    $_SESSION['error'] = 'Transaction not found.';
    header('Location: list.php');
    exit;
}

// Initialize PDF
class PDF extends FPDF {
    function Header() {
        $this->SetFont('Arial', 'B', 16);
        $this->Cell(0, 10, 'Petty Cash Receipt', 0, 1, 'C');
        $this->Ln(5);
        $this->SetFont('Arial', '', 10);
        $this->Cell(0, 10, 'SmartPay360', 0, 1, 'C');
        $this->Ln(5);
    }
    
    function Footer() {
        $this->SetY(-15);
        $this->SetFont('Arial', 'I', 8);
        $this->Cell(0, 10, 'Page ' . $this->PageNo(), 0, 0, 'C');
    }
}

$pdf = new PDF();
$pdf->AddPage();
$pdf->SetFont('Arial', '', 12);

// Transaction Details
$pdf->SetFont('Arial', 'B', 12);
$pdf->Cell(0, 10, 'Transaction Details', 0, 1);
$pdf->SetFont('Arial', '', 12);
$pdf->Cell(50, 8, 'Reference No:', 0, 0);
$pdf->Cell(0, 8, $transaction['reference_no'], 0, 1);
$pdf->Cell(50, 8, 'Branch:', 0, 0);
$pdf->Cell(0, 8, $transaction['branch_name'], 0, 1);
$pdf->Cell(50, 8, 'Type:', 0, 0);
$pdf->Cell(0, 8, ucfirst($transaction['type']), 0, 1);
$pdf->Cell(50, 8, 'Amount:', 0, 0);
$pdf->Cell(0, 8, 'KSh ' . number_format($transaction['amount'], 2), 0, 1);
$pdf->Cell(50, 8, 'Date:', 0, 0);
$pdf->Cell(0, 8, date('d-M-Y', strtotime($transaction['transaction_date'])), 0, 1);
$pdf->Cell(50, 8, 'Description:', 0, 0);
$pdf->MultiCell(0, 8, $transaction['description']);
$pdf->Cell(50, 8, 'Created By:', 0, 0);
$pdf->Cell(0, 8, $transaction['created_by'], 0, 1);
$pdf->Cell(50, 8, 'Supplier:', 0, 0);
$pdf->Cell(0, 8, $transaction['supplier_name'] ?: 'N/A', 0, 1);

// Output PDF
$pdf->Output('D', 'receipt_' . $transaction['reference_no'] . '.pdf');
exit;