<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !isset($_POST['id'])) {
    $_SESSION['error'] = "Invalid submission.";
    header("Location: list.php");
    exit;
}

$id = (int)$_POST['id'];
$support_note = trim($_POST['support_note'] ?? '');
$upload_dir = '../../uploads/petty_cash/';
$uploaded_path = null;

if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0777, true);
}

if (isset($_FILES['support_doc']) && $_FILES['support_doc']['size'] > 0) {
    $file = $_FILES['support_doc'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $allowed = ['pdf', 'jpg', 'jpeg', 'png'];

    if (!in_array($ext, $allowed)) {
        $_SESSION['error'] = "Unsupported file type.";
        header("Location: upload_support.php?id=$id");
        exit;
    }

    $new_filename = uniqid("support_") . "." . $ext;
    $path = $upload_dir . $new_filename;

    if (!move_uploaded_file($file['tmp_name'], $path)) {
        $_SESSION['error'] = "File upload failed.";
        header("Location: upload_support.php?id=$id");
        exit;
    }

    $uploaded_path = $path;
}

// Validate: at least one of file or note must be present
if (!$uploaded_path && empty($support_note)) {
    $_SESSION['error'] = "Upload a file or enter payment support details.";
    header("Location: upload_support.php?id=$id");
    exit;
}

// Update DB and approve
$update = $conn->prepare("
    UPDATE petty_cash_transactions 
    SET support_doc = IFNULL(?, support_doc), support_note = IFNULL(?, support_note), status = 'approved' 
    WHERE id = ?
");
$null_safe_path = $uploaded_path ?? null;
$null_safe_note = $support_note ?: null;
$update->bind_param('ssi', $null_safe_path, $null_safe_note, $id);

if ($update->execute()) {
    $_SESSION['success'] = "Transaction approved with supporting detail.";
} else {
    $_SESSION['error'] = "Failed to approve transaction.";
}

header("Location: list.php");
exit;
