<?php
session_start();
require_once '../../includes/layout.php';
require_once '../../config/db.php';

$query = "SELECT * FROM promotions ORDER BY start_date DESC";
$result = $conn->query($query);
?>

<div class="container mt-4">
    <h2>All Promotions</h2>
    <a href="promotions_upload.php" class="btn btn-primary mb-3">Upload New Promotion</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Promo Name</th>
                <th>Description</th>
                <th>Start</th>
                <th>End</th>
                <th>Status</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['promo_name']) ?></td>
                    <td><?= htmlspecialchars($row['description']) ?></td>
                    <td><?= htmlspecialchars($row['start_date']) ?></td>
                    <td><?= htmlspecialchars($row['end_date']) ?></td>
                    <td><?= $row['active'] ? 'Active' : 'Inactive' ?></td>
                    <td>
                        <a href="edit_promo.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Edit</a>
                        <a href="delete_promo.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
