<?php
session_start();
require_once '../../includes/layout.php';
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $item_code = $_POST['item_code'];
    $old_price = $_POST['old_price'];
    $new_price = $_POST['new_price'];

    $stmt = $conn->prepare("INSERT INTO price_changes (item_code, old_price, new_price, created_at) VALUES (?, ?, ?, NOW())");
    $stmt->bind_param("sdd", $item_code, $old_price, $new_price);
    $stmt->execute();

    $_SESSION['success'] = 'Price change uploaded successfully!';
    header('Location: price_changes_upload.php');
    exit;
}
?>

<div class="container mt-4">
    <h2>Upload Price Change</h2>
    <?php if (isset($_SESSION['success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['success'] ?></div>
        <?php unset($_SESSION['success']); ?>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <label>Item Code</label>
            <input type="text" name="item_code" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>Old Price</label>
            <input type="number" step="0.01" name="old_price" class="form-control" required>
        </div>
        <div class="mb-3">
            <label>New Price</label>
            <input type="number" step="0.01" name="new_price" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success">Upload</button>
    </form>
</div>
