<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ids = $_POST['selected_ids'] ?? [];
    $new_status = $_POST['new_status'] ?? '';

    if (empty($ids) || !in_array($new_status, ['Pending', 'Cleared', 'Bounced', 'Cancelled'])) {
        $_SESSION['error'] = "Invalid selection or status.";
        header("Location: reconcile_cheques.php");
        exit;
    }

    $user_id = $_SESSION['user_id'];

    foreach ($ids as $id) {
        $id = (int)$id;

        // Get current status
        $stmt = $conn->prepare("SELECT cheque_status FROM payments WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $result = $stmt->get_result();
        $current = $result->fetch_assoc();

        if (!$current) continue;

        // Update payment
        $stmt = $conn->prepare("UPDATE payments SET cheque_status = ?, updated_at = NOW(), updated_by = ? WHERE id = ?");
        $stmt->bind_param("sii", $new_status, $user_id, $id);
        $stmt->execute();

        // Log change
        $stmt = $conn->prepare("INSERT INTO cheque_status_logs (payment_id, old_status, new_status, changed_by) VALUES (?, ?, ?, ?)");
        $stmt->bind_param("sssi", $id, $current['cheque_status'], $new_status, $user_id);
        $stmt->execute();
    }

    $_SESSION['success'] = "Status updated for selected cheques.";
    header("Location: reconcile_cheques.php");
    exit;
}
