
<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';


// Initialize filters
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-6 months'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;

$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name")->fetch_all(MYSQLI_ASSOC);

// Build query
$query = "
    SELECT s.name AS supplier_name, 
           DATE_FORMAT(p.payment_date, '%Y-%m') AS payment_month,
           COUNT(p.id) AS payment_count, 
           SUM(p.amount) AS total_amount
    FROM payments p
    JOIN suppliers s ON p.supplier_id = s.id
    WHERE p.payment_date BETWEEN ? AND ?
";
$params = [$start_date, $end_date];
$types = "ss";

if ($supplier_id > 0) {
    $query .= " AND p.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= "i";
}
$query .= " GROUP BY s.id, s.name, payment_month ORDER BY s.name, payment_month";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-chart-line me-2"></i>Supplier Payment Trends</h4>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-4">
                    <label class="form-label">Supplier</label>
                    <select name="supplier_id" class="form-select">
                        <option value="0">All Suppliers</option>
                        <?php foreach ($suppliers as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= $s['id'] == $supplier_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($s['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-1"></i>Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Supplier</th>
                        <th>Month</th>
                        <th>Payment Count</th>
                        <th>Total Amount (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($report_data): ?>
                        <?php foreach ($report_data as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                                <td class="text-center"><?= date('M Y', strtotime($row['payment_month'] . '-01')) ?></td>
                                <td class="text-center"><?= $row['payment_count'] ?></td>
                                <td class="text-end">KSh <?= number_format($row['total_amount'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="4" class="text-center text-muted">No data found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>