
<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';


// Initialize filters
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$method = $_GET['method'] ?? '';

$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name")->fetch_all(MYSQLI_ASSOC);

// Build query
$query = "
    SELECT p.id, p.reference_no, s.name AS supplier_name, p.payment_date, p.method, 
           p.amount, IFNULL(SUM(pa.amount_allocated), 0) AS allocated_amount
    FROM payments p
    JOIN suppliers s ON p.supplier_id = s.id
    LEFT JOIN payment_allocations pa ON p.id = pa.payment_id
    WHERE p.payment_date BETWEEN ? AND ?
    GROUP BY p.id
    HAVING amount > allocated_amount
";
$params = [$start_date, $end_date];
$types = "ss";

if ($supplier_id > 0) {
    $query .= " AND p.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= "i";
}
if ($method) {
    $query .= " AND p.method = ?";
    $params[] = $method;
    $types .= "s";
}
$query .= " ORDER BY p.payment_date DESC";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-exclamation-circle me-2"></i>Unallocated Payments</h4>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Supplier</label>
                    <select name="supplier_id" class="form-select">
                        <option value="0">All Suppliers</option>
                        <?php foreach ($suppliers as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= $s['id'] == $supplier_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($s['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Payment Method</label>
                    <select name="method" class="form-select">
                        <option value="">All Methods</option>
                        <option value="Cash" <?= $method == 'Cash' ? 'selected' : '' ?>>Cash</option>
                        <option value="Cheque" <?= $method == 'Cheque' ? 'selected' : '' ?>>Cheque</option>
                        <option value="MPESA" <?= $method == 'MPESA' ? 'selected' : '' ?>>MPESA</option>
                    </select>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-1"></i>Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Payment ID</th>
                        <th>Reference No</th>
                        <th>Supplier</th>
                        <th>Payment Date</th>
                        <th>Method</th>
                        <th>Amount (KES)</th>
                        <th>Unallocated (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($report_data): ?>
                        <?php foreach ($report_data as $row): ?>
                            <?php $unallocated = $row['amount'] - $row['allocated_amount']; ?>
                            <tr>
                                <td class="text-center"><a href="view.php?id=<?= $row['id'] ?>" class="text-primary"><?= $row['id'] ?></a></td>
                                <td><?= htmlspecialchars($row['reference_no']) ?></td>
                                <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                                <td class="text-center"><?= date('d-M-Y', strtotime($row['payment_date'])) ?></td>
                                <td class="text-center"><?= htmlspecialchars($row['method']) ?></td>
                                <td class="text-end">KSh <?= number_format($row['amount'], 2) ?></td>
                                <td class="text-end text-warning">KSh <?= number_format($unallocated, 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="7" class="text-center text-muted">No unallocated payments found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>