<?php
session_start();
require_once '../../config/db.php';
header('Content-Type: application/json');

$supplier_id = (int)($_GET['supplier_id'] ?? 0);
if (!$supplier_id) { echo json_encode([]); exit; }

$sql = "
  SELECT v.grn_id, v.credit_note_number, v.credit_date, v.branch_id, b.branch_name,
         v.reason, v.amount, v.available
  FROM v_supplier_grn_available v
  LEFT JOIN branches b ON b.id = v.branch_id
  WHERE v.supplier_id = ? AND v.status = 'active' AND v.available > 0
  ORDER BY v.credit_date DESC, v.grn_id DESC
";
$st = $conn->prepare($sql);
$st->bind_param('i', $supplier_id);
$st->execute();
$res = $st->get_result();

$out = [];
while ($r = $res->fetch_assoc()) $out[] = $r;
echo json_encode($out);
