<?php
session_start();
require_once '../../config/db.php';
header('Content-Type: application/json');

$supplier_id = (int)($_GET['supplier_id'] ?? 0);
if (!$supplier_id) { echo json_encode([]); exit; }

$sql = "
  SELECT i.id, i.invoice_number, i.invoice_date, i.total_amount,
         (i.total_amount - COALESCE(a.alloc_sum,0)) AS balance
  FROM invoices i
  LEFT JOIN (
    SELECT invoice_id, SUM(allocated_amount) AS alloc_sum
    FROM supplier_credit_allocations GROUP BY invoice_id
  ) a ON a.invoice_id = i.id
  WHERE i.supplier_id = ?
    AND (i.status IS NULL OR i.status <> 'void')
  HAVING balance > 0
  ORDER BY i.invoice_date DESC, i.id DESC
";
$st = $conn->prepare($sql);
$st->bind_param('i', $supplier_id);
$st->execute();
$res = $st->get_result();

$out = [];
while ($r = $res->fetch_assoc()) $out[] = $r;
echo json_encode($out);
