<?php
session_start();
header('Content-Type: application/json');
require_once '../../config/db.php';

function fail($msg){ echo json_encode(['ok'=>false,'error'=>$msg]); exit; }

$csrf = $_POST['csrf_token'] ?? '';
if ($csrf !== ($_SESSION['csrf_token'] ?? '')) fail('Invalid session.');
$cn_id = (int)($_POST['credit_note_id'] ?? 0);
if (!$cn_id) fail('Missing id.');
$user_id = (int)($_SESSION['user_id'] ?? 0);

// Load header + supplier/branch names
$st = $conn->prepare("SELECT scn.*, s.name AS supplier_name, b.branch_name
                      FROM supplier_credit_notes scn
                      JOIN suppliers s ON s.id=scn.supplier_id
                      LEFT JOIN branches b ON b.id=scn.branch_id
                      WHERE scn.id=? LIMIT 1");
$st->bind_param('i',$cn_id); $st->execute();
$hdr = $st->get_result()->fetch_assoc(); $st->close();
if (!$hdr) fail('Document not found.');
if ($hdr['status']!=='active') fail('Document not active.');
if ((int)$hdr['footer_finalized'] === 1) fail('Already finalized.');

// Fields from wizard
$prepared_by        = trim($_POST['prepared_by'] ?? '');
$sales_name         = trim($_POST['sales_name'] ?? '');
$sales_phone        = trim($_POST['sales_phone'] ?? '');
$sales_id           = trim($_POST['sales_id'] ?? '');
$collection_method  = trim($_POST['collection_method'] ?? '');
$vehicle_ref        = trim($_POST['vehicle_ref'] ?? '');
$collected_flag     = (int)($_POST['collected_flag'] ?? 0);
$collected_by       = trim($_POST['collected_by'] ?? '');
$collected_id       = trim($_POST['collected_id'] ?? '');
$supplier_rep_name  = trim($_POST['supplier_rep_name'] ?? '');
$supplier_rep_phone = trim($_POST['supplier_rep_phone'] ?? '');
$supplier_rep_id    = trim($_POST['supplier_rep_id'] ?? '');

if (!$prepared_by || !$sales_name || !$sales_phone || !$sales_id || !$collection_method || !$supplier_rep_name || !$supplier_rep_phone || !$supplier_rep_id){
  fail('Please fill all required fields.');
}
$collected_at = null;
if ($collected_flag === 1) {
  if (!$collected_by || !$collected_id) fail('Fill collected by & ID when marking as collected.');
  $collected_at = date('Y-m-d H:i:s');
}

// Save footer & lock
$now = date('Y-m-d H:i:s');
$up = $conn->prepare("UPDATE supplier_credit_notes
  SET prepared_by=?, sales_name=?, sales_phone=?, sales_id=?,
      collection_method=?, vehicle_ref=?,
      supplier_rep_name=?, supplier_rep_phone=?, supplier_rep_id=?,
      collected_flag=?, collected_by=?, collected_id=?, collected_at=?,
      footer_finalized=1, footer_finalized_at=?, footer_finalized_by=?,
      workflow_state='awaiting_upload'
  WHERE id=?");
$up->bind_param(
  'ssssssssisssssii',
  $prepared_by, $sales_name, $sales_phone, $sales_id,
  $collection_method, $vehicle_ref,
  $supplier_rep_name, $supplier_rep_phone, $supplier_rep_id,
  $collected_flag, $collected_by, $collected_id, $collected_at,
  $now, $user_id, $cn_id
);
if (!$up->execute()) fail('Save failed: '.$up->error);
$up->close();

// Items for PDF
$it = $conn->prepare("SELECT * FROM supplier_credit_note_items WHERE credit_note_id=? ORDER BY id");
$it->bind_param('i', $cn_id);
$it->execute();
$items = $it->get_result();
$lines = [];
$subtotal=0; $vat=0; $total=0;
while($ln = $items->fetch_assoc()){
  $subtotal += (float)$ln['line_subtotal'];
  $vat      += (float)$ln['line_vat'];
  $total    += (float)$ln['line_total'];
  $lines[] = $ln;
}
$it->close();

// PDF (two copies)
require_once '../../vendor/autoload.php';
use Dompdf\Dompdf;
use Dompdf\Options;

$options = new Options();
$options->set('isRemoteEnabled', true);
$dompdf = new Dompdf($options);

ob_start();
?>
<!DOCTYPE html>
<html>
<head>
  <meta charset="utf-8">
  <style>
    body { font-family: DejaVu Sans, Arial, sans-serif; font-size: 12px; }
    .doc-title{ font-weight:700; font-size:16px; color:#b22222; text-transform:uppercase; }
    .small{ font-size:11px; color:#666; }
    table{ width:100%; border-collapse:collapse; }
    th,td{ border:1px solid #ddd; padding:6px; }
    thead th{ background:#f5f7fa; }
    .text-end{ text-align:right; }
    .muted{ color:#666; }
    .copy-banner{ text-align:center; font-weight:700; margin:4px 0 8px 0; }
    .page-break{ page-break-after: always; }
  </style>
</head>
<body>
<?php
function render_copy($label,$hdr,$lines,$subtotal,$vat,$total,$prepared_by,$sales_name,$sales_phone,$sales_id,$collection_method,$vehicle_ref,$supplier_rep_name,$supplier_rep_phone,$supplier_rep_id,$collected_flag,$collected_by,$collected_id,$collected_at,$now){
?>
<div class="copy-banner"><?= htmlspecialchars($label) ?></div>
<table style="border:none;">
  <tr style="border:none;">
    <td style="border:none;">
      <div style="font-weight:700;">SMARTPAY360</div>
      <div class="small">Goods Return Management</div>
    </td>
    <td style="border:none; text-align:right;">
      <div class="doc-title"><?= htmlspecialchars($hdr['note_type']==='Goods Return Note'?'Goods Return Note':'Supplier Credit Note') ?></div>
      <div class="small">Document #: <?= htmlspecialchars($hdr['credit_note_number']) ?></div>
    </td>
  </tr>
</table>
<table style="border:none; margin-top:8px;">
  <tr style="border:none;">
    <td style="border:none;"><strong>Branch:</strong> <?= htmlspecialchars($hdr['branch_name'] ?? '—') ?></td>
    <td style="border:none;"><strong>Supplier:</strong> <?= htmlspecialchars($hdr['supplier_name']) ?></td>
    <td style="border:none; text-align:right;"><strong>Date:</strong> <?= htmlspecialchars($hdr['credit_date']) ?></td>
  </tr>
  <tr style="border:none;">
    <td style="border:none;"><strong>Reason:</strong> <?= htmlspecialchars($hdr['reason']) ?></td>
    <td style="border:none;" colspan="2"><strong>Invoice:</strong> <?= $hdr['invoice_id'] ? (int)$hdr['invoice_id'] : '—' ?></td>
  </tr>
  <?php if (!empty($hdr['description_note'])): ?>
  <tr style="border:none;">
    <td style="border:none;" colspan="3"><strong>Description:</strong> <?= htmlspecialchars($hdr['description_note']) ?></td>
  </tr>
  <?php endif; ?>
</table>
<table style="margin-top:8px;">
  <thead>
    <tr>
      <th style="width:28px;">#</th>
      <th>SKU</th>
      <th>Item</th>
      <th>Unit</th>
      <th class="text-end">Qty</th>
      <th class="text-end">Price</th>
      <th class="text-end">VAT %</th>
      <th class="text-end">Line Total</th>
    </tr>
  </thead>
  <tbody>
    <?php $n=1; foreach($lines as $ln): ?>
      <tr>
        <td class="text-end"><?= $n++ ?></td>
        <td><?= htmlspecialchars($ln['sku']) ?></td>
        <td><?= htmlspecialchars($ln['item_name']) ?></td>
        <td><?= htmlspecialchars($ln['unit']) ?></td>
        <td class="text-end"><?= number_format((float)$ln['qty'], 3) ?></td>
        <td class="text-end"><?= number_format((float)$ln['unit_price'], 4) ?></td>
        <td class="text-end"><?= number_format((float)$ln['vat_rate'], 2) ?></td>
        <td class="text-end"><?= number_format((float)$ln['line_total'], 2) ?></td>
      </tr>
    <?php endforeach; ?>
  </tbody>
  <tfoot>
    <tr><th colspan="6"></th><th class="text-end">Subtotal</th><th class="text-end"><?= number_format((float)$subtotal,2) ?></th></tr>
    <tr><th colspan="6"></th><th class="text-end">VAT</th><th class="text-end"><?= number_format((float)$vat,2) ?></th></tr>
    <tr><th colspan="6"></th><th class="text-end">Total</th><th class="text-end"><?= number_format((float)$total,2) ?></th></tr>
  </tfoot>
</table>
<table style="margin-top:10px; border:none;">
  <tr style="border:none;">
    <td style="border:none; width:50%; vertical-align:top;">
      <div><strong>Prepared By:</strong> <?= htmlspecialchars($prepared_by) ?></div>
      <div><strong>Salesperson:</strong> <?= htmlspecialchars($sales_name) ?></div>
      <div><strong>Phone:</strong> <?= htmlspecialchars($sales_phone) ?></div>
      <div><strong>ID/Passport:</strong> <?= htmlspecialchars($sales_id) ?></div>
      <div><strong>Collection Method:</strong> <?= htmlspecialchars($collection_method) ?></div>
      <div><strong>Vehicle/Ref:</strong> <?= htmlspecialchars($vehicle_ref) ?></div>
    </td>
    <td style="border:none; width:50%; vertical-align:top;">
      <div><strong>Supplier Rep:</strong> <?= htmlspecialchars($supplier_rep_name) ?></div>
      <div><strong>Phone:</strong> <?= htmlspecialchars($supplier_rep_phone) ?></div>
      <div><strong>ID/Passport:</strong> <?= htmlspecialchars($supplier_rep_id) ?></div>
      <div><strong>Collected?</strong> <?= $collected_flag ? 'Yes' : 'No' ?></div>
      <?php if ($collected_flag): ?>
        <div><strong>Collected By:</strong> <?= htmlspecialchars($collected_by) ?></div>
        <div><strong>Collected ID:</strong> <?= htmlspecialchars($collected_id) ?></div>
        <div><strong>Collected At:</strong> <?= htmlspecialchars($collected_at) ?></div>
      <?php endif; ?>
      <div class="muted" style="margin-top:6px;">Finalized at: <?= htmlspecialchars($now) ?></div>
    </td>
  </tr>
</table>
<table style="margin-top:16px; border:none;">
  <tr style="border:none;">
    <td style="border:none;">
      <div><strong>Prepared by (Sign):</strong></div>
      <div style="border-bottom:1px solid #000; height:18px;"></div>
      <div class="muted">Date: ____________</div>
    </td>
    <td style="border:none;">
      <div><strong>Store/Branch Manager (Sign):</strong></div>
      <div style="border-bottom:1px solid #000; height:18px;"></div>
      <div class="muted">Date: ____________</div>
    </td>
    <td style="border:none;">
      <div><strong>Supplier Acknowledgement (Sign):</strong></div>
      <div style="border-bottom:1px solid #000; height:18px;"></div>
      <div class="muted">Date: ____________</div>
    </td>
  </tr>
</table>
<?php } // render_copy ?>
<?php
render_copy('STORE COPY',$hdr,$lines,$subtotal,$vat,$total,$prepared_by,$sales_name,$sales_phone,$sales_id,$collection_method,$vehicle_ref,$supplier_rep_name,$supplier_rep_phone,$supplier_rep_id,$collected_flag,$collected_by,$collected_id,$collected_at,$now);
?>
<div class="page-break"></div>
<?php
render_copy('SUPPLIER COPY',$hdr,$lines,$subtotal,$vat,$total,$prepared_by,$sales_name,$sales_phone,$sales_id,$collection_method,$vehicle_ref,$supplier_rep_name,$supplier_rep_phone,$supplier_rep_id,$collected_flag,$collected_by,$collected_id,$collected_at,$now);
?>
</body>
</html>
<?php
$html = ob_get_clean();
$dompdf->loadHtml($html, 'UTF-8');
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();

$dir = __DIR__ . '/../../uploads/grn_pdfs/';
if (!is_dir($dir)) @mkdir($dir, 0775, true);
$fname = preg_replace('/[^A-Za-z0-9_-]/','_', ($hdr['note_type'].'_'.$hdr['credit_note_number'])).'.pdf';
$file = $dir.$fname;
file_put_contents($file, $dompdf->output());

$rel = 'uploads/grn_pdfs/'.$fname;
$up2 = $conn->prepare("UPDATE supplier_credit_notes SET pdf_path=? WHERE id=?");
$up2->bind_param('si', $rel, $cn_id);
$up2->execute(); $up2->close();

echo json_encode(['ok'=>true, 'pdf_path'=>$rel]);
