<?php
// FILE: modules/returns/list.php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$q = trim($_GET['q'] ?? '');
$type = $_GET['type'] ?? '';
$from = $_GET['from'] ?? '';
$to   = $_GET['to'] ?? '';

$sql = "SELECT scn.*, s.name AS supplier_name
        FROM supplier_credit_notes scn
        JOIN suppliers s ON s.id = scn.supplier_id
        WHERE 1=1";
$params=[]; $types='';

if ($q !== '') { $sql.=" AND (scn.credit_note_number LIKE CONCAT('%',?,'%') OR s.name LIKE CONCAT('%',?,'%'))"; $params[]=$q; $params[]=$q; $types.='ss'; }
if ($type !== '') { $sql.=" AND scn.note_type=?"; $params[]=$type; $types.='s'; }
if ($from !== '') { $sql.=" AND scn.credit_date>=?"; $params[]=$from; $types.='s'; }
if ($to   !== '') { $sql.=" AND scn.credit_date<=?"; $params[]=$to;   $types.='s'; }
$sql.=" ORDER BY scn.credit_date DESC, scn.id DESC";

$st = $conn->prepare($sql);
if ($types) $st->bind_param($types, ...$params);
$st->execute();
$res = $st->get_result();
?>
<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary"><i class="fas fa-rotate-left me-2"></i> Credit Notes & GRNs</h4>
    <a class="btn btn-primary" href="add.php"><i class="fas fa-plus me-1"></i> New</a>
  </div>

  <form class="card p-3 mb-3">
    <div class="row g-2 align-items-end">
      <div class="col-md-3">
        <label class="form-label">Query</label>
        <input type="text" name="q" class="form-control" value="<?= htmlspecialchars($q) ?>" placeholder="Number or Supplier">
      </div>
      <div class="col-md-2">
        <label class="form-label">Type</label>
        <select name="type" class="form-select">
          <option value="">All</option>
          <option <?= $type==='Credit Note'?'selected':'' ?>>Credit Note</option>
          <option <?= $type==='Goods Return Note'?'selected':'' ?>>Goods Return Note</option>
        </select>
      </div>
      <div class="col-md-2">
        <label class="form-label">From</label>
        <input type="date" name="from" class="form-control" value="<?= htmlspecialchars($from) ?>">
      </div>
      <div class="col-md-2">
        <label class="form-label">To</label>
        <input type="date" name="to" class="form-control" value="<?= htmlspecialchars($to) ?>">
      </div>
      <div class="col-md-3">
        <button class="btn btn-outline-secondary w-100"><i class="fas fa-search me-1"></i> Filter</button>
      </div>
    </div>
  </form>

  <div class="card">
    <div class="table-responsive">
      <table class="table table-striped table-hover align-middle mb-0">
        <thead class="table-light">
        <tr>
          <th>#</th><th>Date</th><th>Number</th><th>Type</th><th>Supplier</th><th class="text-end">Amount</th><th></th>
        </tr>
        </thead>
        <tbody>
        <?php while($r=$res->fetch_assoc()): ?>
          <tr>
            <td><?= (int)$r['id'] ?></td>
            <td><?= htmlspecialchars($r['credit_date']) ?></td>
            <td><?= htmlspecialchars($r['credit_note_number']) ?></td>
            <td><span class="badge bg-<?= $r['note_type']==='Goods Return Note'?'warning':'info' ?>"><?= htmlspecialchars($r['note_type']) ?></span></td>
            <td><?= htmlspecialchars($r['supplier_name']) ?></td>
            <td class="text-end"><?= number_format((float)$r['amount'],2) ?></td>
            <td class="text-end">
              <a class="btn btn-sm btn-outline-primary" href="view.php?id=<?= (int)$r['id'] ?>"><i class="fas fa-eye"></i></a>
            </td>
          </tr>
        <?php endwhile; $st->close(); ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
