<?php
// FILE: modules/returns/settle_deduct_invoice.php
session_start();
require_once '../../config/db.php';

function back($msg){ $_SESSION['error']=$msg; header('Location: settlements.php'); exit; }

if (($_POST['csrf_token'] ?? '') !== ($_SESSION['csrf_token'] ?? '')) back('Invalid session.');
$grn_id     = (int)($_POST['grn_id'] ?? 0);
$invoice_id = (int)($_POST['invoice_id'] ?? 0);
$amount     = (float)($_POST['amount'] ?? 0);
$user_id    = (int)($_SESSION['user_id'] ?? 0);

if (!$grn_id || !$invoice_id || $amount <= 0) back('Missing fields.');

$grn = $conn->query("SELECT * FROM supplier_credit_notes WHERE id={$grn_id}")->fetch_assoc();
if (!$grn || $grn['note_type']!=='Goods Return Note' || $grn['status']!=='active') back('Invalid GRN.');

$avail = $conn->query("SELECT available FROM v_supplier_grn_available WHERE grn_id={$grn_id}")->fetch_assoc();
$grn_available = (float)($avail['available'] ?? 0);
if ($amount > $grn_available + 0.001) back('Amount exceeds GRN available.');

$invoice = $conn->query("SELECT * FROM invoices WHERE id={$invoice_id}")->fetch_assoc();
if (!$invoice || (int)$invoice['supplier_id'] !== (int)$grn['supplier_id']) back('Invoice not valid for this supplier.');

/* -------- live invoice balance (net of allocations) -------- */
$iv = $conn->prepare("
  SELECT i.id,
         (i.total_amount - COALESCE(a.alloc_sum,0)) AS balance
  FROM invoices i
  LEFT JOIN (
    SELECT invoice_id, SUM(allocated_amount) AS alloc_sum
    FROM supplier_credit_allocations GROUP BY invoice_id
  ) a ON a.invoice_id = i.id
  WHERE i.id = ? LIMIT 1
");
$iv->bind_param('i',$invoice_id);
$iv->execute();
$brow = $iv->get_result()->fetch_assoc();
$iv->close();

$inv_balance = (float)($brow['balance'] ?? 0);
if ($amount > $inv_balance + 0.001) back('Amount exceeds invoice balance.');

/* ===================== TRANSACTION ===================== */
$conn->begin_transaction();
try {
  // 1) Create internal Supplier Credit Note (minimal header)
  $cn_number  = 'SCN-INT-'.date('Ymd-His');
  $note_type  = 'Credit Note';
  $today      = date('Y-m-d');
  $reason     = 'Invoice deduction against GRN '.$grn['credit_note_number'];
  $desc       = 'Auto-generated internal SCN for deduction.';
  $sid        = (int)$grn['supplier_id'];
  $branch_id  = (int)$grn['branch_id'];
  $zero       = 0.0;

  $stmt = $conn->prepare("
    INSERT INTO supplier_credit_notes
      (note_type, credit_note_number, supplier_id, branch_id, invoice_id,
       credit_date, reason, description_note, subtotal, vat_amount, amount,
       created_by, status, generated_from_grn_id)
    VALUES
      (?,?,?,?,?,
       ?,?,?, ?,?,?,
       ?, 'active', ?)
  ");
  // types: s s i i i s s s d d d i i  (13 placeholders)
  $stmt->bind_param(
    'ssiiisssdddii',
    $note_type, $cn_number, $sid, $branch_id, $invoice_id,
    $today, $reason, $desc, $zero, $zero, $amount,
    $user_id, $grn_id
  );
  if (!$stmt->execute()) throw new Exception($stmt->error);
  $scn_id = $stmt->insert_id;
  $stmt->close();

  // 2) Post AP credit for the new SCN
  $ap = $conn->prepare("INSERT INTO ap_credit_ledger (supplier_id, credit_note_id, amount) VALUES (?,?,?)");
  $ap->bind_param('iid', $sid, $scn_id, $amount);
  if (!$ap->execute()) throw new Exception($ap->error);
  $ap->close();

  // 3) Match the new SCN to the GRN (knock off pending return)
  $m = $conn->prepare("INSERT INTO supplier_grn_matches (credit_note_id, grn_id, matched_amount, created_by) VALUES (?,?,?,?)");
  $m->bind_param('iidi', $scn_id, $grn_id, $amount, $user_id);
  if (!$m->execute()) throw new Exception($m->error);
  $m->close();

  // 4) Allocate the SCN to the chosen invoice
  $al = $conn->prepare("INSERT INTO supplier_credit_allocations (credit_note_id, invoice_id, allocated_amount, created_by) VALUES (?,?,?,?)");
  $al->bind_param('iidi', $scn_id, $invoice_id, $amount, $user_id);
  if (!$al->execute()) throw new Exception($al->error);
  $al->close();

  // 5) If GRN fully settled now, mark workflow_state
  $left = $conn->query("SELECT available FROM v_supplier_grn_available WHERE grn_id={$grn_id}")->fetch_assoc();
  if ((float)($left['available'] ?? 0) <= 0.001) {
    $conn->query("UPDATE supplier_credit_notes SET workflow_state='settled' WHERE id={$grn_id}");
    if ($conn->error) throw new Exception($conn->error);
  }

  $conn->commit();
  $_SESSION['success'] = 'Deduction created: internal SCN generated, matched to GRN, and allocated to invoice.';
  header('Location: settlements.php'); exit;

} catch (Throwable $e) {
  $conn->rollback();
  back('Failed: '.$e->getMessage());
}
