
<?php
session_start();
require_once '../../config/db.php';

// Log script version
error_log("Using delete.php version: p2k3l4m5-0n1o-6p2q-3r4s-5t6u7v8w9x0y");

// Define timestamp for logging
$timestamp = date('Y-m-d H:i:s');

// Get staff ID
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Log request data
error_log("[$timestamp] Delete request: id=$id, method=" . $_SERVER['REQUEST_METHOD']);

// Handle invalid ID
if ($id <= 0) {
    $_SESSION['error'] = 'Invalid staff ID.';
    header('Location: list.php');
    exit;
}

// Fetch staff details for confirmation (GET) or deletion (POST)
try {
    $query = "SELECT first_name, last_name, national_id FROM staff WHERE id = ?";
    $stmt = $conn->prepare($query);
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $staff = $result->fetch_assoc();

    if (!$staff) {
        $_SESSION['error'] = 'Staff not found.';
        header('Location: list.php');
        exit;
    }
} catch (Exception $e) {
    error_log("[$timestamp] Fetch staff for deletion failed: " . $e->getMessage());
    $_SESSION['error'] = 'Failed to load staff: ' . $e->getMessage();
    header('Location: list.php');
    exit;
}

// Handle deletion (POST)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $conn->begin_transaction();
    try {
        // Verify staff still exists
        $query = "SELECT COUNT(*) as count FROM staff WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('i', $id);
        $stmt->execute();
        if ($stmt->get_result()->fetch_assoc()['count'] == 0) {
            throw new Exception('Staff not found.');
        }

        // Delete staff
        $query = "DELETE FROM staff WHERE id = ?";
        $stmt = $conn->prepare($query);
        $stmt->bind_param('i', $id);
        $stmt->execute();

        $conn->commit();
        $_SESSION['success'] = 'Staff deleted successfully.';
        header('Location: list.php');
        exit;
    } catch (Exception $e) {
        $conn->rollback();
        error_log("[$timestamp] Delete staff failed: " . $e->getMessage());
        $_SESSION['error'] = 'Failed to delete staff: ' . $e->getMessage();
        header('Location: list.php');
        exit;
    }
}

// Close connection for GET request
$conn->close();

// Only include layout and output HTML for GET request (confirmation page)
include '../../includes/layout2.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Delete Staff - StaffSync360</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
</head>
<body>
    <div class="container mt-4">
        <h2 class="mb-4">Delete Staff</h2>
        <?php if (isset($_SESSION['success'])): ?>
            <div class="alert alert-success"><?php echo $_SESSION['success']; unset($_SESSION['success']); ?></div>
        <?php endif; ?>
        <?php if (isset($_SESSION['error'])): ?>
            <div class="alert alert-danger"><?php echo $_SESSION['error']; unset($_SESSION['error']); ?></div>
        <?php endif; ?>
        <div class="card">
            <div class="card-body">
                <h5 class="card-title">Confirm Deletion</h5>
                <p>Are you sure you want to delete the following staff member?</p>
                <dl class="row">
                    <dt class="col-sm-3">Name</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($staff['first_name'] . ' ' . $staff['last_name']); ?></dd>
                    <dt class="col-sm-3">National ID</dt>
                    <dd class="col-sm-9"><?php echo htmlspecialchars($staff['national_id']); ?></dd>
                </dl>
                <form action="delete.php?id=<?php echo $id; ?>" method="POST">
                    <button type="submit" class="btn btn-danger"><i class="fas fa-trash"></i> Confirm Delete</button>
                    <a href="list.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Cancel</a>
                </form>
            </div>
        </div>
    </div>
    <?php include '../../includes/footer.php'; ?>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>