<?php
require_once '../../config/db.php';

$uploadDir = '../../uploads/staff_photos/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}

// Fetch all staff with a photo_url
$sql = "SELECT national_id, photo_url FROM staff WHERE photo_url IS NOT NULL";
$result = $conn->query($sql);

while ($row = $result->fetch_assoc()) {
    $national_id = $row['national_id'];
    $photo_url = $row['photo_url'];

    // Extract Google Drive file ID
    $file_id = null;
    if (preg_match('/id=([^&]+)/', $photo_url, $matches)) {
        $file_id = $matches[1];
    } elseif (preg_match('/\/d\/([^\/]+)/', $photo_url, $matches)) {
        $file_id = $matches[1];
    }

    if ($file_id) {
        $downloadUrl = "https://drive.google.com/uc?export=download&id=$file_id";
        $imagePath = $uploadDir . "nid_{$national_id}.jpg";

        // Download and save image
        $imageData = file_get_contents($downloadUrl);
        if ($imageData) {
            file_put_contents($imagePath, $imageData);
            echo "✅ Saved nid_{$national_id}.jpg<br>";
        } else {
            echo "❌ Failed to download photo for ID $national_id<br>";
        }
    } else {
        echo "❌ Invalid Google Drive URL for ID $national_id<br>";
    }
}
?>
