<?php
require_once '../../config/db.php';

$nid = $_GET['national_id'] ?? '';
if (!preg_match('/^\d{7,9}$/', $nid)) {
    echo "Invalid ID.";
    exit;
}

$query = "SELECT attendance_date, status FROM attendance WHERE national_id = ? ORDER BY attendance_date DESC LIMIT 7";
$stmt = $conn->prepare($query);
$stmt->bind_param('s', $nid);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows === 0) {
    echo "<p>No attendance records found.</p>";
} else {
    echo "<table class='table table-bordered'><thead><tr><th>Date</th><th>Status</th></tr></thead><tbody>";
    while ($row = $result->fetch_assoc()) {
        echo "<tr><td>" . htmlspecialchars($row['attendance_date']) . "</td><td>" . htmlspecialchars($row['status']) . "</td></tr>";
    }
    echo "</tbody></table>";
}
?>
